﻿using System;
using System.Collections.Generic;
using System.Text;

using allegro;
using alleggl;

public class tex : AllegGL
{
    struct _camera
    {
        public double xangle, yangle, zangle;
        public double dist;

        public _camera(double xangle, double yangle, double zangle, double dist)
        {
            this.xangle = xangle;
            this.yangle = yangle;
            this.zangle = zangle;
            this.dist = dist;
        }
    }

    static _camera camera = new _camera(
        0.0, 0.0, 0.0,
        20.0);

    static double angle_speed = 5.0;
    static double dist_speed = 1.0;

    static int frames = 0;
    static volatile int secs;

    static uint _tex;

    static TimerHandler _secs_timer = new TimerHandler(secs_timer);
    static void secs_timer()
    {
        secs++;
    }
    //END_OF_FUNCTION(secs_timer);

    static void set_camera_position()
    {
        OpenGL.glMatrixMode(OpenGL.GL_PROJECTION);
        OpenGL.glLoadIdentity();
        OpenGL.glFrustum(-1.0, 1.0, -1.0, 1.0, 1.0, 40.0);
        OpenGL.glTranslatef(0f, 0f, (float)-camera.dist);
        OpenGL.glRotatef((float)camera.xangle, 1f, 0f, 0f);
        OpenGL.glRotatef((float)camera.yangle, 0f, 1f, 0f);
        OpenGL.glRotatef((float)camera.zangle, 0f, 0f, 1f);
        OpenGL.glMatrixMode(OpenGL.GL_MODELVIEW);
    }

    static void keyboard()
    {
        if (key[KEY_LEFT]) camera.yangle += angle_speed;
        if (key[KEY_RIGHT]) camera.yangle -= angle_speed;

        if (key[KEY_UP]) camera.xangle += angle_speed;
        if (key[KEY_DOWN]) camera.xangle -= angle_speed;

        if (key[KEY_PGUP]) camera.dist -= dist_speed;
        if (key[KEY_PGDN]) camera.dist += dist_speed;

        if (key[KEY_A])
        {
            OpenGL.glDisable(OpenGL.GL_CULL_FACE); // TODO: remove me!
            algl_alert("Alert!", null, null, "OK", null, 0, 0);
            OpenGL.glEnable(OpenGL.GL_CULL_FACE); // TODO: remove me!
        }

        set_camera_position();
        display();
    }

    static void display()
    {
        // Clear the RGB buffer and the depth buffer
        OpenGL.glClear(OpenGL.GL_COLOR_BUFFER_BIT | OpenGL.GL_DEPTH_BUFFER_BIT);

        // Set the modelview matrix to be the identity matrix
        OpenGL.glLoadIdentity();
        // Translate and rotate the object
        OpenGL.glTranslatef(-2.5f, 0.0f, 0.0f);
        OpenGL.glRotatef(-30f, 1.0f, 0.0f, 0.0f);
        OpenGL.glRotatef(30f, 0.0f, 1.0f, 0.0f);
        OpenGL.glRotatef(30f, 0.0f, 0.0f, 1.0f);

        OpenGL.glColor3f(1.0f, 0.0f, 1.0f);

        // Draw the sides of the three-sided pyramid
        OpenGL.glEnable(OpenGL.GL_TEXTURE_2D);
        OpenGL.glBindTexture(OpenGL.GL_TEXTURE_2D, _tex);
        OpenGL.glBegin(OpenGL.GL_TRIANGLE_FAN);
        OpenGL.glTexCoord2f(0, 0); OpenGL.glVertex3d(0, 4, 0);
        OpenGL.glTexCoord2f(1, 0); OpenGL.glVertex3d(0, -4, -4);
        OpenGL.glTexCoord2f(1, 1); OpenGL.glVertex3d(-4, -4, 4);
        OpenGL.glTexCoord2f(0, 1); OpenGL.glVertex3d(4, -4, 4);
        OpenGL.glTexCoord2f(1, 0); OpenGL.glVertex3d(0, -4, -4);
        OpenGL.glEnd();

        OpenGL.glColor3f(0.0f, 1.0f, 1.0f);

        // Draw the base of the pyramid
        OpenGL.glBegin(OpenGL.GL_TRIANGLES);
        OpenGL.glTexCoord2f(1, 0); OpenGL.glVertex3d(0, -4, -4);
        OpenGL.glTexCoord2f(0, 1); OpenGL.glVertex3d(4, -4, 4);
        OpenGL.glTexCoord2f(1, 1); OpenGL.glVertex3d(-4, -4, 4);
        OpenGL.glEnd();


        OpenGL.glLoadIdentity();
        OpenGL.glTranslatef(2.5f, 0.0f, 0.0f);
        OpenGL.glRotatef(45f, 1.0f, 0.0f, 0.0f);
        OpenGL.glRotatef(45f, 0.0f, 1.0f, 0.0f);
        OpenGL.glRotatef(45f, 0.0f, 0.0f, 1.0f);

        OpenGL.glColor3f(0.0f, 1.0f, 0.0f);

        OpenGL.glDisable(OpenGL.GL_TEXTURE_2D);
        // Draw the sides of the cube
        OpenGL.glBegin(OpenGL.GL_QUAD_STRIP);
        OpenGL.glVertex3d(3, 3, -3);
        OpenGL.glVertex3d(3, -3, -3);
        OpenGL.glVertex3d(-3, 3, -3);
        OpenGL.glVertex3d(-3, -3, -3);
        OpenGL.glVertex3d(-3, 3, 3);
        OpenGL.glVertex3d(-3, -3, 3);
        OpenGL.glVertex3d(3, 3, 3);
        OpenGL.glVertex3d(3, -3, 3);
        OpenGL.glVertex3d(3, 3, -3);
        OpenGL.glVertex3d(3, -3, -3);
        OpenGL.glEnd();

        OpenGL.glColor3f(0.0f, 0.0f, 1.0f);

        // Draw the top of the cube
        OpenGL.glBegin(OpenGL.GL_QUADS);
        OpenGL.glVertex3d(-3, -3, -3);
        OpenGL.glVertex3d(3, -3, -3);
        OpenGL.glVertex3d(3, -3, 3);
        OpenGL.glVertex3d(-3, -3, 3);
        OpenGL.glEnd();

        /* Bottom is texture-mapped */
        OpenGL.glEnable(OpenGL.GL_TEXTURE_2D);
        OpenGL.glBindTexture(OpenGL.GL_TEXTURE_2D, _tex);
        OpenGL.glBegin(OpenGL.GL_QUADS);
        OpenGL.glTexCoord2f(0, 0); OpenGL.glVertex3d(-3, 3, -3);
        OpenGL.glTexCoord2f(1, 0); OpenGL.glVertex3d(-3, 3, 3);
        OpenGL.glTexCoord2f(1, 1); OpenGL.glVertex3d(3, 3, 3);
        OpenGL.glTexCoord2f(0, 1); OpenGL.glVertex3d(3, 3, -3);
        OpenGL.glEnd();

        OpenGL.glFlush();

        allegro_gl_flip();

        frames++;
    }

    static void setup_textures()
    {
        PALETTE pal = new PALETTE();
        BITMAP bmp, bmp2;
        int w, h;

        bmp = load_bitmap("mysha.pcx", pal);
        if (!bmp)
        {
            allegro_message("Error loading 'mysha.pcx'");
            //exit(1);
            return;
        }
        w = 128;
        h = 128;
        bmp2 = create_bitmap(w, h);
        stretch_blit(bmp, bmp2, 0, 0, bmp.w, bmp.h, 0, 0, w, h);
        destroy_bitmap(bmp);

        allegro_gl_begin();
        OpenGL.glEnable(OpenGL.GL_TEXTURE_2D);
        OpenGL.glTexEnvi(OpenGL.GL_TEXTURE_ENV, OpenGL.GL_TEXTURE_ENV_MODE, (int)OpenGL.GL_DECAL);

        _tex = allegro_gl_make_texture(bmp2);

        destroy_bitmap(bmp2);
    }

    static int Main()
    {
        allegro_init();

        install_allegro_gl();

        allegro_gl_clear_settings();
        allegro_gl_set(AGL_Z_DEPTH, 16);
        allegro_gl_set(AGL_DOUBLEBUFFER, 1);
        allegro_gl_set(AGL_STENCIL_DEPTH, 0);
        allegro_gl_set(AGL_RENDERMETHOD, 1);
        allegro_gl_set(AGL_COLOR_DEPTH, 16);
        allegro_gl_set(AGL_SUGGEST, AGL_Z_DEPTH | AGL_DOUBLEBUFFER | AGL_COLOR_DEPTH
                        | AGL_STENCIL_DEPTH | AGL_RENDERMETHOD | AGL_WINDOWED);

        if (set_gfx_mode(GFX_OPENGL, 640, 480, 0, 0) < 0)
        {
            allegro_message(string.Format("Error setting OpenGL graphics mode:\n{0}\n" +
                             "Allegro GL error : {1}\n",
                             allegro_error, allegro_gl_error));
            return -1;
        }

        /* We want 24bpp textures */
        allegro_gl_set_texture_format((int)OpenGL.GL_RGB8);

        install_keyboard();
        install_mouse();
        install_timer();

        LOCK_FUNCTION(_secs_timer);
        LOCK_VARIABLE(secs);

        allegro_gl_begin();
        OpenGL.glShadeModel(OpenGL.GL_FLAT);
        OpenGL.glEnable(OpenGL.GL_DEPTH_TEST);
        OpenGL.glCullFace(OpenGL.GL_BACK);
        OpenGL.glEnable(OpenGL.GL_CULL_FACE);
        allegro_gl_end();

        setup_textures();

        install_int(secs_timer, 1000);

        do
        {
            keyboard();
        } while (!key[KEY_ESC]);

        set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);

        allegro_message(string.Format("Frames: {0}, Seconds: {1}, FPS: {2}\n",
                        frames, secs, (float)frames / (float)secs));

        return 0;
    }
}
