﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;

using allegro;
using alleggl;

public class exmasked : AllegGL
{
    public const int FRAME_00_BMP = 0;        /* BMP  */
    public const int FRAME_01_BMP = 1;       /* BMP  */
    public const int FRAME_02_BMP = 2;       /* BMP  */
    public const int FRAME_03_BMP = 3;       /* BMP  */
    public const int FRAME_04_BMP = 4;        /* BMP  */
    public const int FRAME_05_BMP = 5;        /* BMP  */
    public const int FRAME_06_BMP = 6;        /* BMP  */
    public const int FRAME_07_BMP = 7;        /* BMP  */
    public const int FRAME_08_BMP = 8;        /* BMP  */
    public const int FRAME_09_BMP = 9;        /* BMP  */

    static volatile int chrono = 0;

    static TimerHandler _the_timer = new TimerHandler(the_timer);
    static void the_timer()
    {
        chrono++;
    }

    static int render_time;

    static int Main()
    {
        BITMAP texture;
        DATAFILE dat;
        uint[] tex = new uint[11];
        int i = 0, j;

        allegro_init();
        install_allegro_gl();
        install_keyboard();
        install_mouse();

        allegro_gl_clear_settings();
        allegro_gl_set(AGL_COLOR_DEPTH, 32);
        allegro_gl_set(AGL_DOUBLEBUFFER, 1);
        allegro_gl_set(AGL_Z_DEPTH, 24);
        allegro_gl_set(AGL_WINDOWED, TRUE);
        allegro_gl_set(AGL_RENDERMETHOD, 1);
        allegro_gl_set(AGL_SUGGEST, AGL_COLOR_DEPTH | AGL_DOUBLEBUFFER
               | AGL_RENDERMETHOD | AGL_Z_DEPTH | AGL_WINDOWED);

        if (set_gfx_mode(GFX_OPENGL, 640, 480, 0, 0) != 0)
        {
            allegro_message(string.Format("Error setting OpenGL graphics mode:\n{0}\n" +
                             "Allegro GL error : {1}\n",
                             allegro_error, allegro_gl_error));
            return -1;
        }

        install_timer();

        LOCK_FUNCTION(_the_timer);
        LOCK_VARIABLE(chrono);

        install_int(the_timer, 10);

        dat = load_datafile("running.dat");

        if (!dat)
        {
            set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
            allegro_message("Unable to load running.dat!\n");
            return -2;
        }

        allegro_gl_use_mipmapping(TRUE);

        /* Convert running ball thingie */
        for (j = 0; j < 10; j++)
        {
            BITMAP bmp = dat[FRAME_00_BMP + j].dat;
            tex[j] = allegro_gl_make_masked_texture(bmp);
        }
        /* Convert Mysha */
        texture = load_bitmap("mysha.pcx", NULL);
        if (!texture)
        {
            unload_datafile(dat);
            set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
            allegro_message("Unable to load mysha.pcx - did you copy Allegro's " +
                            "here?\n");
            return -3;
        }
        tex[10] = allegro_gl_make_texture(texture);

        /* Now display everything */

        /* Setup OpenGL like we want */
        OpenGL.glEnable(OpenGL.GL_TEXTURE_2D);

        /* Skip pixels which alpha channel is lower than 0.5*/
        OpenGL.glAlphaFunc(OpenGL.GL_GREATER, 0.5f);

        OpenGL.glShadeModel(OpenGL.GL_FLAT);
        OpenGL.glPolygonMode(OpenGL.GL_FRONT, OpenGL.GL_FILL);

        OpenGL.glViewport(0, 0, SCREEN_W, SCREEN_H);
        OpenGL.glMatrixMode(OpenGL.GL_PROJECTION);
        OpenGL.glLoadIdentity();
        OpenGL.glFrustum(-1.0, 1.0, -1.0, 1.0, 1, 60.0);

        /* Set culling mode - not that we have anything to cull */
        OpenGL.glEnable(OpenGL.GL_CULL_FACE);
        OpenGL.glFrontFace(OpenGL.GL_CCW);

        OpenGL.glMatrixMode(OpenGL.GL_MODELVIEW);


        while (keypressed()) readkey();

        render_time = chrono;
        do
        {
            int screen_w = SCREEN_W;
            int screen_h = SCREEN_H;

            OpenGL.glClear(OpenGL.GL_COLOR_BUFFER_BIT | OpenGL.GL_DEPTH_BUFFER_BIT);

            OpenGL.glLoadIdentity();
            OpenGL.glTranslatef(-10.0f, -10.0f, -10.0f);

            /* Draw BG */
            OpenGL.glBindTexture(OpenGL.GL_TEXTURE_2D, tex[10]);
            OpenGL.glBegin(OpenGL.GL_QUADS);
            OpenGL.glTexCoord2f(0, 0);
            OpenGL.glVertex2f(0, 0);

            OpenGL.glTexCoord2f(1, 0);
            OpenGL.glVertex2f(20, 0);

            OpenGL.glTexCoord2f(1, 1);
            OpenGL.glVertex2f(20, 20);

            OpenGL.glTexCoord2f(0, 1);
            OpenGL.glVertex2f(0, 20);
            OpenGL.glEnd();

            i = (chrono / 10) % 10;

            /* Draw running ball thingie */

            /* Enable removing of thingie's transparent pixels */
            OpenGL.glEnable(OpenGL.GL_ALPHA_TEST);
            OpenGL.glLoadIdentity();
            if (screen_w != 0 && screen_h != 0)
            {
                OpenGL.glTranslatef(mouse_x * 20.0f / screen_w - 10.0f,
                             mouse_y * -20.0f / screen_h + 10.0f, -9.99f);
            }
            OpenGL.glRotatef(chrono, 0f, 0f, 1.0f);
            OpenGL.glBindTexture(OpenGL.GL_TEXTURE_2D, tex[i]);

            OpenGL.glBegin(OpenGL.GL_QUADS);
            OpenGL.glTexCoord2f(0, 0);
            OpenGL.glVertex2f(-1.0f, -1.0f);

            OpenGL.glTexCoord2f(1, 0);
            OpenGL.glVertex2f(1.0f, -1.0f);

            OpenGL.glTexCoord2f(1, 1);
            OpenGL.glVertex2f(1.0f, 1.0f);

            OpenGL.glTexCoord2f(0, 1);
            OpenGL.glVertex2f(-1.0f, 1.0f);
            OpenGL.glEnd();
            OpenGL.glDisable(OpenGL.GL_ALPHA_TEST); /* Disable removing of transparent pixels */

            allegro_gl_flip();

            render_time++;
            while (!keypressed() && render_time > chrono)
            {
                rest(2);
            }
        } while (!keypressed());

        return 0;
    }
}