﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;

using allegro;
using alleggl;

public class extextur : AllegGL
{
    static int Main()
    {
        BITMAP mysha, texture;
        uint[] tex = new uint[18];
        FONT agl_font;
        int i, j;

        allegro_init();
        install_allegro_gl();
        install_keyboard();
        install_timer();

        allegro_gl_clear_settings();
        allegro_gl_set(AGL_COLOR_DEPTH, 32);
        allegro_gl_set(AGL_DOUBLEBUFFER, 1);
        allegro_gl_set(AGL_Z_DEPTH, 24);
        allegro_gl_set(AGL_WINDOWED, TRUE);
        allegro_gl_set(AGL_RENDERMETHOD, 1);
        allegro_gl_set(AGL_SUGGEST, AGL_COLOR_DEPTH | AGL_DOUBLEBUFFER
                                  | AGL_RENDERMETHOD | AGL_Z_DEPTH | AGL_WINDOWED);

        Debug.Write("Swicthing screen modes...\n");

        if (set_gfx_mode(GFX_OPENGL, 800, 600, 0, 0) != 0)
        {
            allegro_message(string.Format("Error setting OpenGL graphics mode:\n{0}\n" +
                            "Allegro GL error : {1}\n",
                            allegro_error, allegro_gl_error));
            return -1;
        }

        Debug.Write("Loading texture\n");

        /* Load mysha.pcx */
        for (j = 0; j < 3; j++)
        {
            int flag;

            set_color_depth(8 * (j + 2));
            mysha = load_bitmap("mysha.pcx", NULL);

            if (!mysha)
            {
                set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
                allegro_message("Unable to load mysha.pcx - please copy Allegro's " +
                                "in this directory.\n");
                return -2;
            }

            texture = create_sub_bitmap(mysha, 64, 64, 64, 64);

            Debug.Write("Converting textures\n");

            /* Convert to texture using different modes */
            flag = AGL_TEXTURE_FLIP;
            tex[j * 6 + 0] = allegro_gl_make_texture_ex(flag, texture, -1);
            tex[j * 6 + 1] = allegro_gl_make_texture_ex(flag, texture, (int)OpenGL.GL_RGB8);
            tex[j * 6 + 2] = allegro_gl_make_texture_ex(flag, texture, (int)OpenGL.GL_RGBA8);

            flag |= AGL_TEXTURE_MIPMAP;
            tex[j * 6 + 3] = allegro_gl_make_texture_ex(flag, texture, -1);
            tex[j * 6 + 4] = allegro_gl_make_texture_ex(flag, texture, (int)OpenGL.GL_RGB8);
            tex[j * 6 + 5] = allegro_gl_make_texture_ex(flag, texture, (int)OpenGL.GL_RGBA8);

            destroy_bitmap(texture);
            destroy_bitmap(mysha);
        }
        Debug.Write("Converted all textures\n");

        /* Convert Allegro font */
        agl_font = allegro_gl_convert_allegro_font_ex(font,
                                      AGL_FONT_TYPE_TEXTURED, (float)-1.0, (int)OpenGL.GL_INTENSITY8);

        Debug.Write("Converted font\n");

        /* Now display everything */

        /* Setup OpenGL like we want */
        OpenGL.glEnable(OpenGL.GL_TEXTURE_2D);
        OpenGL.glEnable(OpenGL.GL_BLEND);

        Debug.Write("Setup OpenGL\n");

        do
        {
            OpenGL.glClear(OpenGL.GL_COLOR_BUFFER_BIT | OpenGL.GL_DEPTH_BUFFER_BIT);

            /* Draw all quads */
            for (j = 0; j < 3; j++)
            {

                allegro_gl_set_projection();

                for (i = 0; i < 6; i++)
                {
                    float x, y, w, h;

                    OpenGL.glBindTexture(OpenGL.GL_TEXTURE_2D, tex[j * 6 + i]);
                    OpenGL.glBegin(OpenGL.GL_QUADS);

                    x = (float)i * SCREEN_W / 6.0f;
                    y = (float)j * SCREEN_H / 6.0f;
                    w = (float)SCREEN_W / 6.0f;
                    h = w;

                    OpenGL.glTexCoord2f(0, 1);
                    OpenGL.glVertex2f(x, y);

                    OpenGL.glTexCoord2f(1, 1);
                    OpenGL.glVertex2f(x + w - 1, y);

                    OpenGL.glTexCoord2f(1, 0);
                    OpenGL.glVertex2f(x + w - 1, y + h - 1);

                    OpenGL.glTexCoord2f(0, 0);
                    OpenGL.glVertex2f(x, y + h - 1);

                    x = i * SCREEN_W / 6.0f;
                    y = j * SCREEN_H / 6.0f;
                    w = SCREEN_W / 6.0f / 2;
                    h = w;

                    OpenGL.glTexCoord2f(0, 1);
                    OpenGL.glVertex2f(x, y);

                    OpenGL.glTexCoord2f(1, 1);
                    OpenGL.glVertex2f(x + w - 1, y);

                    OpenGL.glTexCoord2f(1, 0);
                    OpenGL.glVertex2f(x + w - 1, y + h - 1);

                    OpenGL.glTexCoord2f(0, 0);
                    OpenGL.glVertex2f(x, y + h - 1);
                    OpenGL.glEnd();
                }

                OpenGL.glBlendFunc(OpenGL.GL_SRC_ALPHA, OpenGL.GL_ONE_MINUS_SRC_ALPHA);
                OpenGL.glTranslatef(-0.375f, -0.375f, 0f);

                for (i = 0; i < 6; i++)
                {
                    string text = (i % 3 == 0 ? "default" : i % 3 == 1
                         ? "RGB8" : "RGBA8");

                    allegro_gl_printf(agl_font, i * SCREEN_W / 6,
                                      j * SCREEN_H / 6, 0,
                             makecol(255, 255, 255), string.Format("{0}bpp {1}", (j + 2) * 8, text));
                    allegro_gl_printf(agl_font, i * SCREEN_W / 6,
                                      j * SCREEN_H / 6 + 8, 0,
                             makecol(255, 255, 255), string.Format("{0}", i < 3 ? "" : "mipmaped"));
                }
                allegro_gl_unset_projection();
                OpenGL.glBlendFunc(OpenGL.GL_ONE, OpenGL.GL_ZERO);
            }

            OpenGL.glViewport(0, 0, SCREEN_W, SCREEN_H);
            OpenGL.glMatrixMode(OpenGL.GL_PROJECTION);
            OpenGL.glLoadIdentity();
            OpenGL.glFrustum(-1.0, 1.0, -1.0, 1.0, 1, 1000.0);

            OpenGL.glMatrixMode(OpenGL.GL_MODELVIEW);
            OpenGL.glLoadIdentity();

            /* Draw a large mysha */
            OpenGL.glBindTexture(OpenGL.GL_TEXTURE_2D, tex[0]);
            OpenGL.glTranslatef(-10.0f, -10.0f, -10.0f);

            OpenGL.glBegin(OpenGL.GL_QUADS);
            OpenGL.glTexCoord2f(0, 0);
            OpenGL.glVertex2f(0, 0);

            OpenGL.glTexCoord2f(1, 0);
            OpenGL.glVertex2f(20, 0);

            OpenGL.glTexCoord2f(1, 1);
            OpenGL.glVertex2f(20, 8);

            OpenGL.glTexCoord2f(0, 1);
            OpenGL.glVertex2f(0, 8);
            OpenGL.glEnd();

            allegro_gl_flip();
            rest(2);

        } while (!keypressed());

        return 0;
    }
}
