using allegro;
using System.Runtime.InteropServices;
using System;

namespace mathtest
{
    class mathtest : Allegro
    {
        static int errno;

        const int SIN = 1;
        const int COS = 2;
        const int TAN = 3;
        const int ASIN = 4;
        const int ACOS = 5;
        const int ATAN = 6;
        const int SQRT = 7;

        const int ADD = 1;
        const int SUB = 2;
        const int MUL = 3;
        const int DIV = 4;

        //static char[] calc_str = new char[80];
        static string calc_str = "0";

        static int calc_value;
        static int calc_operation;
        static int calc_clear_flag;

        //static DIALOG[] calculator;

        const int CALC_STR = 3;



        static void redraw(DIALOG d)
        {
            object_message(calculator[CALC_STR], MSG_DRAW, 0);

            if (d)
                object_message(d, MSG_DRAW, 0);
        }



        static void reset_calc()
        {
            calc_value = 0;
            calc_operation = 0;
            calc_clear_flag = FALSE;
        }



        static int get_calc_value()
        {
            // Avoid using culture dependent decimal separator
            System.Globalization.CultureInfo ci = System.Globalization.CultureInfo.InstalledUICulture;
            System.Globalization.NumberFormatInfo ni = (System.Globalization.NumberFormatInfo)ci.NumberFormat.Clone();
            ni.NumberDecimalSeparator = ".";

            //double d = atof(calc_str);
            double d = double.Parse(calc_str, ni);
            return ftofix(d);
        }



        static void set_calc_value(int v)
        {
            int c, l;
            int has_dot;
            char[] b = new char[80];
            double d = fixtof(v);

            //sprintf(b, "%.8f", d);
            b = string.Format("{0:0.########}", d).Replace(",", ".").ToCharArray();


            l = 0;
            has_dot = FALSE;

            //for (c = 0; b[c]; c++)
            for (c = 0; c < b.Length; c++)
            {
                if ((b[c] >= '0') && (b[c] <= '9'))
                {
                    l++;
                    if (l > 8)
                    {
                        //b[c] = (char)0;
                        Array.Resize<char>(ref b, c);
                        break;
                    }
                }
                else
                    if (b[c] == '.')
                        has_dot = TRUE;
            }

            if (has_dot != 0)
            {
                for (c = c - 1; c >= 0; c--)
                {
                    if (b[c] == '0')
                        //b[c] = (char)0;
                        Array.Resize<char>(ref b, c);
                    else
                    {
                        if (b[c] == '.')
                            //b[c] = (char)0;
                            Array.Resize<char>(ref b, c);
                        break;
                    }
                }
            }

            if (errno > 0)
                //sprintf(calc_str, "-E- (%s)", b);
                calc_str = string.Format("-E- ({0})", new string(b));
            else
                //strcpy(calc_str, b);
                calc_str = new string(b);

            errno = 0;
        }



        static int right_text_proc(int msg, IntPtr d, int c)
        {
            int len;

            if (msg == MSG_DRAW)
            {
                //len = strlen(d.dp);
                //len = Marshal.PtrToStringAnsi(((DIALOG)d).dp).Length;
                len = calc_str.Length;
                //textout_ex(screen, font, Marshal.PtrToStringAnsi(((DIALOG)d).dp), ((DIALOG)d).x + ((DIALOG)d).w - len * 8, ((DIALOG)d).y, ((DIALOG)d).fg, ((DIALOG)d).bg);
                textout_ex(screen, font, calc_str, ((DIALOG)d).x + ((DIALOG)d).w - len * 8, ((DIALOG)d).y, ((DIALOG)d).fg, ((DIALOG)d).bg);
                rectfill(screen, ((DIALOG)d).x, ((DIALOG)d).y, ((DIALOG)d).x + ((DIALOG)d).w - len * 8 - 1, ((DIALOG)d).y + ((DIALOG)d).h, ((DIALOG)d).bg);
            }

            return D_O_K;
        }
        static DIALOG_PROC d_right_text_proc = new DIALOG_PROC(right_text_proc);



        static int input_proc(int msg, IntPtr d, int c)
        {
            int c1, c2;
            //char *s = d.dp;
            //string s = Marshal.PtrToStringAnsi(((DIALOG)d).dp);
            string s = ((char)((DIALOG)d).key).ToString();
            int ret = d_button_proc(msg, d, c);

            if (ret == D_CLOSE)
            {
                //if ((calc_clear_flag != 0) && (s[0] != '+'))
                //    //strcpy(calc_str, "0");
                //    calc_str = "0";
                ////else if (strncmp(calc_str, "-E-", 3) == 0)
                //else if (string.Compare(calc_str, 0, "-E-", 0, 3) == 0)
                //{
                //    redraw(d);
                //    return D_O_K;
                //}

                //calc_clear_flag = FALSE;

                //if (s[0] == '.')
                //{
                //    for (c1 = 0; calc_str[c1] != 0; c1++)
                //        if (calc_str[c1] == '.')
                //            break;

                //    if (calc_str[c1] == 0)
                //        //strcat(calc_str, ".");
                //        calc_str = ".";
                //}
                //else if (s[0] == '+')
                //{
                //    //if (calc_str[0] == '-')
                //    //    memmove(calc_str, calc_str + 1, strlen(calc_str + 1) + 1);
                //    //else
                //    //{
                //    //    memmove(calc_str + 1, calc_str, strlen(calc_str) + 1);
                //    //    calc_str[0] = '-';
                //    //}
                //}
                //else
                //{
                //    //if (strcmp(calc_str, "0") == 0)
                //    if (string.Compare(calc_str, "0") == 0)
                //        //calc_str[0] = 0;
                //        calc_str = string.Empty;
                //    //else if (strcmp(calc_str, "-0") == 0)
                //    else if (string.Compare(calc_str, "-0") == 0)
                //        //strcpy(calc_str, "-");
                //        calc_str = "-";

                //    c2 = 0;
                //    //for (c1 = 0; calc_str[c1] != 0; c1++)
                //    //    if ((calc_str[c1] >= '0') && (calc_str[c1] <= '9'))
                //    //        c2++;

                //    if (c2 < 8)
                //        //strcat(calc_str, s);
                //        calc_str += s;
                //}

                redraw(d);
                return D_O_K;
            }

            return ret;
        }
        static DIALOG_PROC d_input_proc = new DIALOG_PROC(input_proc);



        static int unary_operator(int msg, IntPtr d, int c)
        {
            int x;
            int ret = d_button_proc(msg, d, c);

            if (ret == D_CLOSE)
            {
                x = get_calc_value();

                switch (((DIALOG)d).d1)
                {

                    case SIN:
                        x = fixsin(x);
                        break;

                    case COS:
                        x = fixcos(x);
                        break;

                    case TAN:
                        x = fixtan(x);
                        break;

                    case ASIN:
                        x = fixasin(x);
                        break;

                    case ACOS:
                        x = fixacos(x);
                        break;

                    case ATAN:
                        x = fixatan(x);
                        break;

                    case SQRT:
                        x = fixsqrt(x);
                        break;
                }

                set_calc_value(x);
                calc_clear_flag = TRUE;

                redraw(d);
                return D_O_K;
            }

            return ret;
        }
        static DIALOG_PROC d_unary_operator = new DIALOG_PROC(unary_operator);



        static int work_out()
        {
            int x;

            x = get_calc_value();

            switch (calc_operation)
            {

                case ADD:
                    x = fixadd(calc_value, x);
                    break;

                case SUB:
                    x = fixsub(calc_value, x);
                    break;

                case MUL:
                    x = fixmul(calc_value, x);
                    break;

                case DIV:
                    x = fixdiv(calc_value, x);
                    break;
            }

            set_calc_value(x);
            reset_calc();
            calc_clear_flag = TRUE;

            redraw(NULL);
            return D_O_K;
        }
        static MenuCallback d_work_out = new MenuCallback(work_out);



        static int equals_proc(int msg, IntPtr d, int c)
        {
            int ret = d_button_proc(msg, d, c);

            if (ret == D_CLOSE)
            {
                ret = work_out();
                redraw(d);
            }

            return ret;
        }
        static DIALOG_PROC d_equals_proc = new DIALOG_PROC(equals_proc);



        static int binary_operator(int msg, IntPtr d, int c)
        {
            int ret = d_button_proc(msg, d, c);

            if (ret == D_CLOSE)
            {
                work_out();

                calc_value = get_calc_value();
                calc_operation = ((DIALOG)d).d1;
                calc_clear_flag = TRUE;

                redraw(d);
                return D_O_K;
            }

            return ret;
        }
        static DIALOG_PROC d_binary_operator = new DIALOG_PROC(binary_operator);



        static int clearer()
        {
            reset_calc();
            //strcpy(calc_str, "0");
            redraw(NULL);
            return D_O_K;
        }
        static MenuCallback d_clearer = new MenuCallback(clearer);



        static int clear_proc(int msg, IntPtr d, int c)
        {
            int ret = d_button_proc(msg, d, c);

            if (ret == D_CLOSE)
            {
                ret = clearer();
                redraw(d);
            }

            return ret;
        }
        new static DIALOG_PROC d_clear_proc = new DIALOG_PROC(clear_proc);


        //static DIALOGS calculator = new DIALOGS(34);
        static DIALOGS calculator = new DIALOGS(33);


        static IntPtr test;

        static int Main()
        {
            test = Marshal.StringToHGlobalAnsi("7");
            /* (dialog proc)     (x)   (y)   (w)   (h)   (fg)  (bg)  (key) (flags)  (d1)     (d2)           (dp)        (dp2) (dp3) */
            calculator[0] = new DIALOG("d_shadow_box_proc", 0, 0, 193, 173, 255, 8, 0, 0, 0, 0, NULL, NULL, NULL);
            calculator[1] = new DIALOG(d_box_proc, 8, 10, 177, 21, 16, 255, 0, 0, 0, 0, NULL, NULL, NULL);
            calculator[2] = new DIALOG(d_box_proc, 10, 12, 173, 17, 255, 16, 0, 0, 0, 0, NULL, NULL, NULL);
            calculator[3] = new DIALOG(d_right_text_proc, 24, 16, 144, 8, 255, 16, 0, 0, 0, 0, Marshal.StringToHGlobalAnsi(calc_str), NULL, NULL);

            calculator[4] = new DIALOG(d_unary_operator, 16, 48, 49, 13, 16, 255, 0, D_EXIT, SIN, 0, Marshal.StringToHGlobalAnsi("sin"), NULL, NULL);
            calculator[5] = new DIALOG(d_unary_operator, 72, 48, 49, 13, 16, 255, 0, D_EXIT, COS, 0, Marshal.StringToHGlobalAnsi("cos"), NULL, NULL);
            calculator[6] = new DIALOG(d_unary_operator, 128, 48, 49, 13, 16, 255, 0, D_EXIT, TAN, 0, Marshal.StringToHGlobalAnsi("tan"), NULL, NULL);

            calculator[7] = new DIALOG(d_unary_operator, 16, 64, 49, 13, 16, 255, 0, D_EXIT, ASIN, 0, Marshal.StringToHGlobalAnsi("asin"), NULL, NULL);
            calculator[8] = new DIALOG(d_unary_operator, 72, 64, 49, 13, 16, 255, 0, D_EXIT, ACOS, 0, Marshal.StringToHGlobalAnsi("acos"), NULL, NULL);
            calculator[9] = new DIALOG(d_unary_operator, 128, 64, 49, 13, 16, 255, 0, D_EXIT, ATAN, 0, Marshal.StringToHGlobalAnsi("atan"), NULL, NULL);

            calculator[10] = new DIALOG(d_input_proc, 8, 88, 33, 13, 16, 255, '7', D_EXIT, 0, 0, Marshal.StringToHGlobalAnsi("7"), NULL, NULL);
            calculator[11] = new DIALOG(d_input_proc, 44, 88, 33, 13, 16, 255, '8', D_EXIT, 0, 0, Marshal.StringToHGlobalAnsi("8"), NULL, NULL);
            calculator[12] = new DIALOG(d_input_proc, 80, 88, 33, 13, 16, 255, '9', D_EXIT, 0, 0, Marshal.StringToHGlobalAnsi("9"), NULL, NULL);
            calculator[13] = new DIALOG(d_binary_operator, 116, 88, 33, 13, 16, 255, '/', D_EXIT, DIV, 0, Marshal.StringToHGlobalAnsi("/"), NULL, NULL);
            calculator[14] = new DIALOG(d_clear_proc, 152, 88, 33, 13, 16, 255, 'c', D_EXIT, 0, 0, Marshal.StringToHGlobalAnsi("C"), NULL, NULL);
            calculator[15] = new DIALOG("d_keyboard_proc", 0, 0, 0, 0, 0, 0, 0, 0, KEY_DEL, KEY_BACKSPACE, Marshal.GetFunctionPointerForDelegate(d_clearer), NULL, NULL);

            calculator[16] = new DIALOG(d_input_proc, 8, 108, 33, 13, 16, 255, '4', D_EXIT, 0, 0, Marshal.StringToHGlobalAnsi("4"), NULL, NULL);
            calculator[17] = new DIALOG(d_input_proc, 44, 108, 33, 13, 16, 255, '5', D_EXIT, 0, 0, Marshal.StringToHGlobalAnsi("5"), NULL, NULL);
            calculator[18] = new DIALOG(d_input_proc, 80, 108, 33, 13, 16, 255, '6', D_EXIT, 0, 0, Marshal.StringToHGlobalAnsi("6"), NULL, NULL);
            calculator[19] = new DIALOG(d_binary_operator, 116, 108, 33, 13, 16, 255, '*', D_EXIT, MUL, 0, Marshal.StringToHGlobalAnsi("*"), NULL, NULL);
            calculator[20] = new DIALOG(d_button_proc, 152, 108, 33, 13, 16, 255, 27, D_EXIT, 0, 0, Marshal.StringToHGlobalAnsi("off"), NULL, NULL);

            calculator[21] = new DIALOG(d_input_proc, 8, 128, 33, 13, 16, 255, '1', D_EXIT, 0, 0, Marshal.StringToHGlobalAnsi("1"), NULL, NULL);
            calculator[22] = new DIALOG(d_input_proc, 44, 128, 33, 13, 16, 255, '2', D_EXIT, 0, 0, Marshal.StringToHGlobalAnsi("2"), NULL, NULL);
            calculator[23] = new DIALOG(d_input_proc, 80, 128, 33, 13, 16, 255, '3', D_EXIT, 0, 0, Marshal.StringToHGlobalAnsi("3"), NULL, NULL);
            calculator[24] = new DIALOG(d_binary_operator, 116, 128, 33, 13, 16, 255, '-', D_EXIT, SUB, 0, Marshal.StringToHGlobalAnsi("-"), NULL, NULL);
            calculator[25] = new DIALOG(d_unary_operator, 152, 128, 33, 13, 16, 255, 0, D_EXIT, SQRT, 0, Marshal.StringToHGlobalAnsi("sqr"), NULL, NULL);

            calculator[26] = new DIALOG(d_input_proc, 8, 148, 33, 13, 16, 255, '0', D_EXIT, 0, 0, Marshal.StringToHGlobalAnsi("0"), NULL, NULL);
            calculator[27] = new DIALOG(d_input_proc, 44, 148, 33, 13, 16, 255, '.', D_EXIT, 0, 0, Marshal.StringToHGlobalAnsi("."), NULL, NULL);
            calculator[28] = new DIALOG(d_input_proc, 80, 148, 33, 13, 16, 255, 0, D_EXIT, 0, 0, Marshal.StringToHGlobalAnsi("+/-"), NULL, NULL);
            calculator[29] = new DIALOG(d_binary_operator, 116, 148, 33, 13, 16, 255, '+', D_EXIT, ADD, 0, Marshal.StringToHGlobalAnsi("+"), NULL, NULL);
            calculator[30] = new DIALOG(d_equals_proc, 152, 148, 33, 13, 16, 255, '=', D_EXIT, 0, 0, Marshal.StringToHGlobalAnsi("="), NULL, NULL);
            calculator[31] = new DIALOG("d_keyboard_proc", 0, 0, 0, 0, 0, 0, 13, 0, 0, 0, Marshal.GetFunctionPointerForDelegate(d_work_out), NULL, NULL);

            calculator[32] = new DIALOG("d_yield_proc", 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL);
            calculator[calculator.Length - 1] = new DIALOG(NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL);




            int i;

            if (allegro_init() != 0)
                return 1;
            install_mouse();
            install_keyboard();
            install_timer();

            if (set_gfx_mode(GFX_AUTODETECT, 320, 200, 0, 0) != 0)
            {
                if (set_gfx_mode(GFX_SAFE, 320, 200, 0, 0) != 0)
                {
                    set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
                    allegro_message(string.Format("Error setting graphics mode\n{0}\n", allegro_error));
                    return 1;
                }
            }

            textout_ex(screen, font, "Angles are binary, 0-255", 0, 0, palette_color[8], 0);
            reset_calc();
            //strcpy(calc_str, "0");
            calc_str = "0";
            errno = 0;

            /* we set up colors to match screen color depth (in case it changed) */
            for (i = 0; calculator[i].proc != NULL; i++)
            {
                calculator[i].fg = palette_color[calculator[i].fg];
                calculator[i].bg = palette_color[calculator[i].bg];
            }

            centre_dialog(calculator);
            do_dialog(calculator, -1);

            return 0;
        }
    }
}
