using System;

using allegro;

namespace play
{
    class play : Allegro
    {
        static void format_id(string buf, int n, int driver_id, string name)
        {
            char[] tmp = new char[8];

            if (driver_id < 256) {
               //sprintf(tmp, "%d", driver_id);
                tmp = driver_id.ToString().ToCharArray();
            }
            else {
               tmp[0] = (char)((driver_id >> 24) & 0xFF);
               tmp[1] = (char)((driver_id >> 16) & 0xFF);
               tmp[2] = (char)((driver_id >> 8) & 0xFF);
               tmp[3] = (char)(driver_id & 0xFF);
               tmp[4] = (char)0;
            }

            //sprintf(buf+strlen(buf), "\t%s\t- %s\n", tmp, name);
            buf = string.Format("\t{0}\t- {1}\n", tmp, name);
        }



        static void usage()
        {
            _DRIVER_INFO[] digi, midi;
            //char *msg = malloc(4096);
            string msg;
            int i;

            //strcpy(msg, "\nSound code test program for Allegro " ALLEGRO_VERSION_STR ", " ALLEGRO_PLATFORM_STR "\n");
            //strcat(msg, "By Shawn Hargreaves, " ALLEGRO_DATE_STR "\n\n");
            //strcat(msg, "Usage: play [digital driver [midi driver]] files.(mid|voc|wav)\n\n");
            //strcat(msg, "Digital drivers:\n\n");
            msg = "\nSound code test program for Allegro " + ALLEGRO_VERSION_STR + ", " + ALLEGRO_PLATFORM_STR + "\n";
            msg += "By Shawn Hargreaves, " + ALLEGRO_DATE_STR + "\n\n";
            msg += "Usage: play [digital driver [midi driver]] files.(mid|voc|wav)\n\n";
            msg += "Digital drivers:\n\n";

            if (system_driver.digi_drivers != NULL)
                digi = system_driver._digi_drivers();
            else
                digi = _digi_driver_list;

            for (i = 0; digi[i].driver != NULL; i++)
            {
                IntPtr p = digi[i].driver;
                DIGI_DRIVER d = p;
                allegro_message(d.ascii_name);

             //   format_id(msg, i, digi[i].id, ((DIGI_DRIVER)digi[i].driver).ascii_name);
            }

            //strcat(msg, "\nMIDI drivers:\n\n");
            msg += "\nMIDI drivers:\n\n";

            if (system_driver.midi_drivers != NULL)
                midi = system_driver._midi_drivers();
            else
                midi = _midi_driver_list;

            for (i = 0; midi[i].driver != NULL; i++)
                format_id(msg, i, midi[i].id, ((MIDI_DRIVER)midi[i].driver).ascii_name);

            //strcat(msg, "\nIf you don't specify the card, Allegro will auto-detect (ie. guess :-)\n");
            msg += "\nIf you don't specify the card, Allegro will auto-detect (ie. guess :-)\n";

            allegro_message(msg);
            //free(msg);
        }



        static int is_driver_id(string s)
        {
            int i;

            for (i = 0; s[i] > 0; i++)
            {
                if (((s[i] < '0') || (s[i] > '9')) &&
                ((s[i] < 'A') || (s[i] > 'Z')) &&
                ((s[i] < 'a') || (s[i] > 'z')))
                    return FALSE;

                if (i >= 4)
                    return FALSE;
            }

            return TRUE;
        }



        static int get_driver_id(string s)
        {
            char[] tmp = new char[4];
            //char *endp;
            int val, i;

            //val = strtol(s, &endp, 0);
            val = int.Parse(s);
            //if (!*endp)
            //   return val;

            tmp[0] = tmp[1] = tmp[2] = tmp[3] = ' ';

            for (i = 0; i < 4; i++)
            {
                if (s[i] > 0)
                    //tmp[i] = utoupper(s[i]);
                    tmp[i] = s[i].ToString().ToUpper()[0];
                else
                    break;
            }

            return AL_ID(tmp[0], tmp[1], tmp[2], tmp[3]);
        }



        static int Main(string[] argv)
        {
            int digicard = -1;
            int midicard = -1;
            int k = 0;
            int vol = 255;
            int pan = 128;
            int freq = 1000;
            int paused = FALSE;
            //char[] buf = new char[80];
            string buf;
            IntPtr[] item = new IntPtr[9];
            int[] is_midi = new int[9];
            int item_count = 0;
            long old_midi_pos = -1;
            int doodle_note = -1;
            char[] midi_msg = new char[3];
            int[] doodle_pitch = { 60, 62, 64, 65, 67, 69, 71, 72, 74, 76, 77, 79 };
            int white, black, red, green;
            int i;

            if (allegro_init() != 0)
                return 1;

            if (argv.Length < 1)
            {
                usage();
                return 1;
            }

            if ((argv.Length > 1) && (is_driver_id(argv[0]) != 0))
            {
                digicard = get_driver_id(argv[0]);
                if ((argv.Length > 2) && (is_driver_id(argv[1]) != 0))
                {
                    midicard = get_driver_id(argv[1]);
                    i = 3;
                }
                else
                    i = 2;
            }
            else
                i = 1;

            install_timer();
            install_keyboard();

            if (set_gfx_mode(GFX_AUTODETECT, 640, 480, 0, 0) != 0)
            {
                if (set_gfx_mode(GFX_SAFE, 640, 480, 0, 0) != 0)
                {
                    set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
                    allegro_message(string.Format("Error setting graphics mode\n{0}\n", allegro_error));
                    return 1;
                }
            }
            set_palette(default_palette);

            white = makecol(255, 255, 255);
            black = makecol(0, 0, 0);
            red = makecol(192, 0, 0);
            green = makecol(0, 192, 0);

            clear_to_color(screen, white);

            if (install_sound(digicard, midicard, null) != 0)
            {
                set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
                allegro_message(string.Format("Error initialising sound system\n{0}\n", allegro_error));
                return 1;
            }

            textprintf_centre_ex(screen, font, SCREEN_W / 2, 12, red, -1, "Sound code test program for Allegro " + ALLEGRO_VERSION_STR + ", " + ALLEGRO_PLATFORM_STR);
            textprintf_centre_ex(screen, font, SCREEN_W / 2, 24, red, -1, "By Shawn Hargreaves, " + ALLEGRO_DATE_STR);

            textprintf_ex(screen, font, 0, 84, green, -1, string.Format("Digital sound driver: {0}", digi_driver.name));
            textprintf_ex(screen, font, 0, 96, green, -1, string.Format("Description: {0}", digi_driver.desc));
            textprintf_ex(screen, font, 0, 108, green, -1, string.Format("Voices: {0}", digi_driver.voices));

            textprintf_ex(screen, font, 0, 132, green, -1, string.Format("Midi music driver: {0}", midi_driver.name));
            textprintf_ex(screen, font, 0, 144, green, -1, string.Format("Description: {0}", midi_driver.desc));
            textprintf_ex(screen, font, 0, 156, green, -1, string.Format("Voices: {0}", midi_driver.voices));

            while ((i < argv.Length - 1) && (item_count < 9))
            {
                if ((string.Compare(get_extension(argv[i]).ToString(), "voc", true) == 0) || (string.Compare(get_extension(argv[i]).ToString(), "wav", true) == 0))
                {
                    item[item_count] = load_sample(argv[i]);
                    is_midi[item_count] = 0;
                }
                else if (string.Compare(get_extension(argv[i]).ToString(), "mid", true) == 0)
                {
                    item[item_count] = load_midi(argv[i]);
                    is_midi[item_count] = 1;
                }
                else
                {
                    textprintf_ex(screen, font, 32, 192 + item_count * 12, red, -1, string.Format("Unknown file type '{0}'", argv[i]));
                    item[item_count] = NULL;
                    item_count++;
                    i++;
                    continue;
                }

                if (item[item_count] == NULL)
                {
                    textprintf_ex(screen, font, 32, 192 + item_count * 12, red, -1, string.Format("Error reading {0}", argv[i]));
                }
                else
                {
                    textprintf_ex(screen, font, 32, 192 + item_count * 12, black, -1, string.Format("{0}: {1}", item_count + 1, argv[i]));
                }

                item_count++;
                i++;
            }

            textprintf_centre_ex(screen, font, SCREEN_W / 2, SCREEN_H - 48, red, -1, "Press a number 1-9 to trigger a sample or midi file");
            textprintf_centre_ex(screen, font, SCREEN_W / 2, SCREEN_H - 36, red, -1, "v/V changes sfx volume, p/P changes sfx pan, and f/F changes sfx frequency");
            textprintf_centre_ex(screen, font, SCREEN_W / 2, SCREEN_H - 24, red, -1, "space pauses/resumes MIDI playback, and the arrow keys seek through the tune");
            textprintf_centre_ex(screen, font, SCREEN_W / 2, SCREEN_H - 12, red, -1, "Use the function keys to doodle a tune");

            k = '1';      /* start sound automatically */

            do
            {
                switch (k & 0xFF)
                {

                    case 'v':
                        vol -= 8;
                        if (vol < 0)
                            vol = 0;
                        set_volume(vol, -1);
                        break;

                    case 'V':
                        vol += 8;
                        if (vol > 255)
                            vol = 255;
                        set_volume(vol, -1);
                        break;

                    case 'p':
                        pan -= 8;
                        if (pan < 0)
                            pan = 0;
                        break;

                    case 'P':
                        pan += 8;
                        if (pan > 255)
                            pan = 255;
                        break;

                    case 'f':
                        freq -= 8;
                        if (freq < 1)
                            freq = 1;
                        break;

                    case 'F':
                        freq += 8;
                        break;

                    case '0':
                        play_midi(NULL, FALSE);
                        paused = FALSE;
                        break;

                    case ' ':
                        if (paused != 0)
                        {
                            midi_resume();
                            paused = FALSE;
                        }
                        else
                        {
                            midi_pause();
                            paused = TRUE;
                        }
                        break;

                    default:
                        if ((k >> 8) == KEY_LEFT)
                        {
                            for (i = (int)midi_pos - 1; (midi_pos == old_midi_pos) && (midi_pos > 0); i--)
                                midi_seek(i);
                            paused = FALSE;
                        }
                        else if ((k >> 8) == KEY_RIGHT)
                        {
                            for (i = (int)midi_pos + 1; (midi_pos == old_midi_pos) && (midi_pos > 0); i++)
                                midi_seek(i);
                            paused = FALSE;
                        }
                        if ((k >> 8) == KEY_DOWN)
                        {
                            for (i = (int)midi_pos - 16; (midi_pos == old_midi_pos) && (midi_pos > 0); i--)
                                midi_seek(i);
                            paused = FALSE;
                        }
                        else if ((k >> 8) == KEY_UP)
                        {
                            for (i = (int)midi_pos + 16; (midi_pos == old_midi_pos) && (midi_pos > 0); i++)
                                midi_seek(i);
                            paused = FALSE;
                        }
                        else if (((k & 0xFF) >= '1') && ((k & 0xFF) < '1' + item_count))
                        {
                            k = (k & 0xFF) - '1';
                            if (item[k] != NULL)
                            {
                                if (is_midi[k] != 0)
                                {
                                    play_midi((MIDI)item[k], FALSE);
                                    paused = FALSE;
                                }
                                else
                                    play_sample((SAMPLE)item[k], vol, pan, freq, FALSE);
                            }
                        }
                        else
                        {
                            k >>= 8;
                            if (((k >= KEY_F1) && (k <= KEY_F10)) ||
                            ((k >= KEY_F11) && (k <= KEY_F12)))
                            {
                                if (doodle_note >= 0)
                                {
                                    midi_msg[0] = (char)0x80;
                                    midi_msg[1] = (char)doodle_pitch[doodle_note];
                                    midi_msg[2] = (char)0;
                                    midi_out(midi_msg, 3);
                                }

                                if ((k >= KEY_F1) && (k <= KEY_F10))
                                    doodle_note = k - KEY_F1;
                                else
                                    doodle_note = 10 + k - KEY_F11;

                                midi_msg[0] = (char)0x90;
                                midi_msg[1] = (char)doodle_pitch[doodle_note];
                                midi_msg[2] = (char)127;
                                midi_out(midi_msg, 3);
                            }
                        }
                        break;
                }

                old_midi_pos = midi_pos;

                buf = string.Format("        midi pos: {0}    vol: {1}    pan: {2}    freq: {3}        ", midi_pos, vol, pan, freq);
                textout_centre_ex(screen, font, buf, SCREEN_W / 2, SCREEN_H - 120, black, white);

                do
                {
                } while ((!keypressed()) && (midi_pos == old_midi_pos));

                if (keypressed())
                    k = readkey();
                else
                    k = 0;

            } while ((k & 0xFF) != 27);

            for (i = 0; i < item_count; i++)
            {
                if (item[i] == NULL)
                    continue;
                if (is_midi[i] != 0)
                    destroy_midi((MIDI)item[i]);
                else
                    destroy_sample((SAMPLE)item[i]);
            }

            return 0;
        }
    }
}
