﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Drawing;

namespace sharprd
{
    public class IconListBox : ListBox
    {
        public IconListBox()
        {
            this.DrawMode = DrawMode.OwnerDrawFixed;
        }

        protected override void OnDrawItem(System.Windows.Forms.DrawItemEventArgs e)
        {
            e.DrawBackground();
            e.DrawFocusRectangle();
            RdpConnection item;
            Rectangle bounds = e.Bounds;

            try
            {
                item = (RdpConnection)Items[e.Index];
                Size imageSize = item.StatusImage.Size;

                if (item.StatusImage != null)
                {
                    e.Graphics.DrawImage(item.StatusImage, bounds.Left, bounds.Top);
                    e.Graphics.DrawString(item.ToString(), e.Font, new SolidBrush(e.ForeColor), bounds.Left + imageSize.Width, bounds.Top);
                }
                else
                {
                    e.Graphics.DrawString(item.ToString(), e.Font, new SolidBrush(e.ForeColor), bounds.Left, bounds.Top);
                }
            }
            catch
            {
                if (e.Index > 0)
                {
                    e.Graphics.DrawString(Items[e.Index].ToString(), e.Font, new SolidBrush(e.ForeColor), bounds.Left, bounds.Top);
                }
                else
                {
                    e.Graphics.DrawString(Text, e.Font, new SolidBrush(e.ForeColor), bounds.Left, bounds.Top);
                }
            }
            base.OnDrawItem(e);
        }
    }
}
