using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Collections;

namespace sharprd
{
    public partial class NewRDPConnection : Form
    {
        private const string computerNameMessage1 = "The computer name field is blank. Enter a full remote computer name";
        private const string computerNameMessage2 = "You will be asked for credentials when you connect";

        private RdpConnection connection;

        public RdpConnection Connection
        {
            get
            {
                return connection;
            }
            set
            {
                connection = value;

                txtName.Text = connection.Name;
                txtComputer.Text = connection.Computer;
                txtDomain.Text = connection.Domain;
                txtUsername.Text = connection.Username;
                txtPassword.Text = connection.Password;

                switch (connection.ColorDepth)
                {
                    case RdpConnection.ColorDepths.Color256:
                        cboColorDepth.SelectedIndex = 0;
                        break;
                    case RdpConnection.ColorDepths.HighColor15:
                        cboColorDepth.SelectedIndex = 1;
                        break;
                    case RdpConnection.ColorDepths.HighColor16:
                        cboColorDepth.SelectedIndex = 2;
                        break;
                    case RdpConnection.ColorDepths.TrueColor24:
                        cboColorDepth.SelectedIndex = 3;
                        break;
                    case RdpConnection.ColorDepths.TrueColor32:
                        cboColorDepth.SelectedIndex = 4;
                        break;
                }

                chkConsole.Checked = connection.Console;
                chkPrinters.Checked = connection.Printers;
                chkClipboard.Checked = connection.Clipboard;
                chkDrives.Checked = connection.Drives;

                cboDisplayMode.SelectedIndex = connection.DisplayMode == RdpConnection.DisplayModes.Fullscreen ? 0 : 1;
                chkDisplayConnectionBar.Checked = connection.DisplayConnectionBar;

                cboPerformance.SelectedIndex = (int)connection.PerformancePreset;

                chkDesktopBackground.Checked = connection.DesktopBackground;
                chkFontSmoothing.Checked = connection.FontSmoothing;
                chkDesktopComposition.Checked = connection.DesktopComposition;
                chkWindowContents.Checked = connection.WindowContents;
                chkMenuAnimation.Checked = connection.MenuAnimation;
                chkVisualStyles.Checked = connection.VisualStyles;
                chkPersistentBitmapCaching.Checked = connection.PersistentBitmapCaching;
            }
        }

        public NewRDPConnection()
        {
            InitializeComponent();

            cboColorDepth.SelectedIndex = 0;

            cboDisplayMode.SelectedIndex = 1;

            lblComputerName.Text = computerNameMessage1;
        }

        private void ButtonClick(object sender, EventArgs e)
        {
            if (sender == btnOk)
            {
                if (string.IsNullOrEmpty(txtName.Text))
                {
                    Error("The connection name is blank");
                    return;
                }

                if (string.IsNullOrEmpty(txtComputer.Text))
                {
                    Error("The computer name is blank or it contains invalid characters. Try typing it again.\n\nInvalid characters include; spaces, tabs, ; : < > * + = \\ | ! , \"");
                    return;
                }



                DialogResult = DialogResult.OK;

                if (connection == null)
                {
                    connection = new RdpConnection();
                }

                connection.Name = txtName.Text;
                connection.Computer = txtComputer.Text;
                connection.Domain = txtDomain.Text;
                connection.Username = txtUsername.Text;
                connection.Password = txtPassword.Text;

                RdpConnection.ColorDepths colorDepth = 0;
                switch (cboColorDepth.SelectedIndex)
                {
                    case 0:
                        colorDepth = RdpConnection.ColorDepths.Color256;
                        break;
                    case 1:
                        colorDepth = RdpConnection.ColorDepths.HighColor15;
                        break;
                    case 2:
                        colorDepth = RdpConnection.ColorDepths.HighColor16;
                        break;
                    case 3:
                        colorDepth = RdpConnection.ColorDepths.TrueColor24;
                        break;
                    case 4:
                        colorDepth = RdpConnection.ColorDepths.TrueColor32;
                        break;
                }
                connection.ColorDepth = colorDepth;

                connection.Console = chkConsole.Checked;
                connection.Printers = chkPrinters.Checked;    
                connection.Clipboard = chkClipboard.Checked;
                connection.Drives = chkDrives.Checked;

                connection.DisplayMode = cboDisplayMode.SelectedIndex == 0 ? RdpConnection.DisplayModes.Fullscreen : RdpConnection.DisplayModes.Tabbed;
                connection.DisplayConnectionBar = chkDisplayConnectionBar.Checked;

                connection.PerformancePreset = (RdpConnection.PerformancePresets)cboPerformance.SelectedIndex;

                connection.DesktopBackground = chkDesktopBackground.Checked;
                connection.FontSmoothing = chkFontSmoothing.Checked;
                connection.DesktopComposition = chkDesktopComposition.Checked;
                connection.WindowContents = chkWindowContents.Checked;
                connection.MenuAnimation = chkMenuAnimation.Checked;
                connection.VisualStyles = chkVisualStyles.Checked;
                connection.PersistentBitmapCaching = chkPersistentBitmapCaching.Checked;
            }

            Close();
        }

        private void txtComputer_TextChanged(object sender, EventArgs e)
        {
            lblComputerName.Text = computerNameMessage1;
            chkSaveCredentials.Visible = false;

            if (!string.IsNullOrEmpty(txtComputer.Text))
            {
                lblComputerName.Text = computerNameMessage2;
                chkSaveCredentials.Visible = true;
            }
        }

        private void Error(string text)
        {
            MessageBox.Show(text, "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
        }

        private void cboPerformance_SelectedIndexChanged(object sender, EventArgs e)
        {
            chkDesktopBackground.Checked = false;
            chkFontSmoothing.Checked = false;
            chkDesktopComposition.Checked = false;
            chkWindowContents.Checked = false;
            chkMenuAnimation.Checked = false;
            chkVisualStyles.Checked = false;
            chkPersistentBitmapCaching.Checked = false;

            switch (cboPerformance.SelectedIndex)
            {
                case 0:
                    chkPersistentBitmapCaching.Checked = true;
                    break;
                case 1:
                    chkVisualStyles.Checked = true;
                    chkPersistentBitmapCaching.Checked = true;
                    break;
                case 2:
                case 3:
                    chkDesktopComposition.Checked = true;
                    chkVisualStyles.Checked = true;
                    chkPersistentBitmapCaching.Checked = true;
                    break;
                case 4:
                case 5:
                    chkDesktopBackground.Checked = true;
                    chkFontSmoothing.Checked = true;
                    chkDesktopComposition.Checked = true;
                    chkWindowContents.Checked = true;
                    chkMenuAnimation.Checked = true;
                    chkVisualStyles.Checked = true;
                    chkPersistentBitmapCaching.Checked = true;
                    break;
            }
        }
    }
}