using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Collections;
using System.Xml.Serialization;
using System.IO;
using System.Xml;

using sharprd.Properties;

namespace sharprd
{
    public partial class MainWindow : Form, IObserver
    {
        public MainWindow()
        {
            InitializeComponent();

            if (File.Exists("connections.xml"))
            {
                FileStream stream = new FileStream("connections.xml", FileMode.Open);
                try
                {
                    XmlSerializer serializer = new XmlSerializer(typeof(RdpConnection[]));
                    if (stream.Length > 0)
                    {
                        XmlReader reader = new XmlTextReader(stream);
                        RdpConnection[] connections = (RdpConnection[])serializer.Deserialize(reader);
                        reader.Close();

                        lstConnections.Items.AddRange(connections);
                    }
                }
                catch (Exception ex)
                {
                    Error("Unable to load connections\n" + ex.ToString());
                }
                finally
                {
                    stream.Close();
                }
            }

            RefreshUI();
        }

        private void NewEdit(object sender, EventArgs e)
        {
            if (sender == btnEdit && lstConnections.SelectedItem == null) return;

            NewRDPConnection dialog = new NewRDPConnection();
            if (sender == btnEdit) dialog.Connection = (RdpConnection)lstConnections.SelectedItem;

            if (dialog.ShowDialog(this) == DialogResult.OK && sender != btnEdit)
            {
                lstConnections.Items.Add(dialog.Connection);
            }

            RefreshUI();
        }

        private void exitToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void btnBrowser_Click(object sender, EventArgs e)
        {
            if (sender != btnBrowser) btnBrowser.Checked = !btnBrowser.Checked;
            splitContainer1.Panel1Collapsed = !btnBrowser.Checked;
            if (splitContainer1.Panel1Collapsed) splitContainer1.Panel1.Hide();
        }

        private void MainWindow_FormClosing(object sender, FormClosingEventArgs e)
        {
            foreach (RdpConnection connection in lstConnections.Items)
            {
                if (connection.Connected) connection.Page.Disconnect();
            }

            StreamWriter writer = new StreamWriter("connections.xml");
            try
            {
                XmlSerializer serializer = new XmlSerializer(typeof(RdpConnection[]));                

                RdpConnection[] array = new RdpConnection[lstConnections.Items.Count];
                for (int i = 0; i < array.Length; i++)
                {
                    array[i] = (RdpConnection)lstConnections.Items[i];
                }

                serializer.Serialize(writer, array);
            }
            catch (Exception ex)
            {
                Error("Unable to save connections\n" + ex.ToString());
                e.Cancel = true;
            }
            finally
            {
                writer.Close();
            }

            Settings.Default.SplitterDistance = splitContainer1.SplitterDistance;
            Settings.Default.Save();
        }

        private void Connect(object sender, EventArgs e)
        {
            if (lstConnections.SelectedItem != null)
            {
                RdpConnection connection = (RdpConnection)lstConnections.SelectedItem;

                if (connection.Connected)
                {
                    connection.Page.Disconnect();
                }
                else
                {
                    RDPTabPage page = new RDPTabPage(connection);
                    page.Attach(this);

                    tabContainer.TabPages.Add(page);
                    page.Connect();
                    tabContainer.SelectTab(page);

                    connection.Page = page;
                }
            }

            RefreshUI();
        }

        private void Error(string text)
        {
            MessageBox.Show(text, "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
        }

        private void listBox1_SelectedIndexChanged(object sender, EventArgs e)
        {
            RefreshUI();
        }

        public void RefreshUI()
        {
            btnEdit.Enabled = false;
            btnConnect.Enabled = false;
            btnConnect.Text = "Connect";
            btnConnect.Image = sharprd.Properties.Resources.activate;

            if (lstConnections.SelectedItem != null)
            {
                btnEdit.Enabled = true;
                btnConnect.Enabled = true;

                RdpConnection connection = (RdpConnection)lstConnections.SelectedItem;
                if (connection.Connected)
                {
                    btnConnect.Text = "Disconnect";
                    btnConnect.Image = sharprd.Properties.Resources.deactivate;
                }
            }
        }

        #region IObserver Members

        void IObserver.Update()
        {
            RefreshUI();
        }

        #endregion

        private void Delete(object sender, EventArgs e)
        {
            if (lstConnections.SelectedItem != null && MessageBox.Show("Are you sure?", "Confirm", MessageBoxButtons.YesNo, MessageBoxIcon.Question) == DialogResult.Yes)
            {
                lstConnections.Items.RemoveAt(lstConnections.SelectedIndex);
            }

            RefreshUI();
        }

        private void MainWindow_Resize(object sender, EventArgs e)
        {
            if (FormWindowState.Minimized == WindowState)
            {
                Hide();
                notifyIcon.Visible = true;
            }
        }

        private void notifyIcon_DoubleClick(object sender, EventArgs e)
        {
            Show();
            // TODO: restore previous state
            WindowState = FormWindowState.Maximized;
            notifyIcon.Visible = false;
        }

        private void MainWindow_Shown(object sender, EventArgs e)
        {
            splitContainer1.SplitterDistance = Settings.Default.SplitterDistance;
        }
    }
}