﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace sharpsyntax
{
    public partial class MatchGroupForm : Form
    {
        private MatchGroup group;
        private Color selectedColor;

        public MatchGroup Group
        {
            get { return group; }
            set
            {
                group = value;

                txtName.Text = group.Name;
                cboType.SelectedIndex = (int)group.Type;
                SelectedColor = group.Color;

                lstTokens.Items.AddRange(group.Tokens.ToArray());

                if (lstTokens.Items.Count > 0) lstTokens.SelectedIndex = 0;
            }
        }

        public Color SelectedColor
        {
            get { return selectedColor; }
            set
            {
                selectedColor = value;
                btnColor.BackColor = selectedColor;
            }
        }

        public MatchGroupForm()
        {
            InitializeComponent();

            foreach (string type in Enum.GetNames(typeof(MatchGroup.MatchType)))
            {
                cboType.Items.Add(type);
            }

            cboType.SelectedIndex = 0;

            SelectedColor = Color.Black;
        }

        private void btnOk_Click(object sender, EventArgs e)
        {
            if (string.IsNullOrEmpty(txtName.Text))
            {
                MessageBox.Show(this, "Name required", "Info", MessageBoxButtons.OK, MessageBoxIcon.Information);
                return;
            }

            group = new MatchGroup(txtName.Text, (MatchGroup.MatchType)cboType.SelectedIndex, selectedColor);
            group.Tokens.Clear();
            foreach (object token in lstTokens.Items)
            {
                group.Tokens.Add((string)token);
            }

            DialogResult = DialogResult.OK;
            Close();
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            Close();
        }

        private void btnColor_Click(object sender, EventArgs e)
        {
            colorDialog.Color = selectedColor;

            if (colorDialog.ShowDialog(this) == DialogResult.OK)
            {
                SelectedColor = colorDialog.Color;
            }
        }

        private void lstTokens_SelectedIndexChanged(object sender, EventArgs e)
        {
            txtToken.Text = (string)lstTokens.SelectedItem;
        }

        private void btnAdd_Click(object sender, EventArgs e)
        {
            if (!string.IsNullOrEmpty(txtToken.Text))
            {
                if (lstTokens.Items.Contains(txtToken.Text))
                {
                    MessageBox.Show(this, "Token already exists", "Info", MessageBoxButtons.OK, MessageBoxIcon.Information);
                }
                else
                {
                    lstTokens.Items.Add(txtToken.Text);
                    txtToken.Text = string.Empty;
                }
            }
        }

        private void btnEdit_Click(object sender, EventArgs e)
        {
            if (!string.IsNullOrEmpty(txtToken.Text))
            {
                if (lstTokens.Items.Contains(txtToken.Text))
                {
                    MessageBox.Show(this, "Token already exists", "Info", MessageBoxButtons.OK, MessageBoxIcon.Information);
                }
                else
                {
                    lstTokens.SelectedItem = txtToken.Text;
                    lstTokens.Invalidate();
                }
            }
        }

        private void btnDelete_Click(object sender, EventArgs e)
        {
            lstTokens.Items.RemoveAt(lstTokens.SelectedIndex);
        }

        private void btnParse_Click(object sender, EventArgs e)
        {
            if (MessageBox.Show("String will be splitted into tokens where spaces are found. Continue?", "Confirm", MessageBoxButtons.YesNo) == DialogResult.Yes)
            {
                string[] tokens = txtToken.Text.Split(new char[] { ' ' });
                foreach (string token in tokens)
                {
                    if (!lstTokens.Items.Contains(token))
                    {
                        lstTokens.Items.Add(token);
                    }
                }
                txtToken.Text = string.Empty;
            }
        }
    }
}
