﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace sharpsyntax
{
    public partial class LanguageForm : Form
    {
        private Language language;

        public Language Language
        {
            get { return language; }
            set
            {
                language = value;

                txtName.Text = language.Name;
                cboCaseSensitive.SelectedIndex = language.CaseSensitive ? 0 : 1;
                cboGroups.Items.AddRange(language.Groups.ToArray());

                if (cboGroups.Items.Count > 0) cboGroups.SelectedIndex = 0;
            }
        }

        public LanguageForm()
        {
            InitializeComponent();

            cboCaseSensitive.SelectedIndex = 0;
        }

        private void btnOk_Click(object sender, EventArgs e)
        {
            if (string.IsNullOrEmpty(txtName.Text))
            {
                MessageBox.Show(this, "Name required", "Info", MessageBoxButtons.OK, MessageBoxIcon.Information);
                return;
            }

            language = new Language(txtName.Text, cboCaseSensitive.SelectedIndex == 0);
            language.Groups.Clear();
            foreach (object group in cboGroups.Items)
            {
                language.Groups.Add((MatchGroup)group);
            }

            DialogResult = DialogResult.OK;
            Close();
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            Close();
        }

        private void btnAddGroup_Click(object sender, EventArgs e)
        {
            MatchGroupForm form = new MatchGroupForm();
            if (form.ShowDialog(this) == DialogResult.OK)
            {
                MatchGroup group = form.Group;
                cboGroups.Items.Add(group);
                cboGroups.SelectedIndex = cboGroups.Items.Count - 1;
            }
        }

        private void btnEditGroup_Click(object sender, EventArgs e)
        {
            if (cboGroups.SelectedItem == null)
            {
                MessageBox.Show(this, "Select a group", "Info", MessageBoxButtons.OK, MessageBoxIcon.Information);
                return;
            }

            MatchGroupForm form = new MatchGroupForm();
            form.Group = (MatchGroup)cboGroups.SelectedItem;
            if (form.ShowDialog(this) == DialogResult.OK)
            {
                // Delete and remove old group
                MatchGroup group = (MatchGroup)cboGroups.SelectedItem;
                cboGroups.Items.RemoveAt(cboGroups.SelectedIndex);
                cboGroups.Invalidate();

                group = form.Group;
                cboGroups.Items.Add(group);

                cboGroups.SelectedIndex = cboGroups.Items.Count - 1;
            }
        }

        private void btnDeleteGroup_Click(object sender, EventArgs e)
        {

        }
    }
}
