﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using System.Xml.Serialization;

namespace sharpsyntax
{
    public class MatchGroup
    {
        public enum MatchType
        {
            Symbol = 0,
            Word,
            RegularExpression
        }

        private string name;
        private MatchType type;
        // Color
        [XmlElement("A")]
        public int A;
        [XmlElement("R")]
        public int R;
        [XmlElement("G")]
        public int G;
        [XmlElement("B")]
        public int B;
        private List<string> tokens;
        private bool enabled;

        public string Name
        {
            get { return name; }
            set { name = value; }
        }

        public MatchType Type
        {
            get { return type; }
            set { type = value; }
        }

        [XmlIgnore()]
        public Color Color
        {
            get { return Color.FromArgb(A, R, G, B); }
            set {  
                this.A = value.A;
                this.R = value.R;
                this.G = value.G;
                this.B = value.B;
            }
        }

        public List<string> Tokens
        {
            get { return tokens; }
            set { tokens = value; }
        }

        public bool Enabled
        {
            get { return enabled; }
            set { enabled = value; }
        }

        public MatchGroup()
        {
        }

        public MatchGroup(string name, MatchType type, Color color)
        {
            this.name = name;
            this.type = type;
            this.Color = color;

            this.tokens = new List<string>();
            this.Enabled = true;
        }

        public override string ToString()
        {
            return name;
        }
    }
}
