﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Text.RegularExpressions;
using System.Runtime.InteropServices;
using System.IO;
using System.Reflection;

namespace sharpsyntax
{
    public partial class MainWindow : Form
    {
        public MainWindow()
        {
            InitializeComponent();

            DirectoryInfo info = new DirectoryInfo(".");
            FileInfo[] files = info.GetFiles("*.xml");

            foreach (FileInfo file in files)
            {
                Language language = Language.Deserialize(file.FullName);
                cboLanguages.Items.Add(language);
            }

            if (cboLanguages.Items.Count > 0) cboLanguages.SelectedIndex = 0;
        }

        private void languageComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (cboLanguages.SelectedItem != null)
            {
                syntaxTextBox.Language = (Language)cboLanguages.SelectedItem;
            }
        }

        private void addButton_Click(object sender, EventArgs e)
        {
            LanguageForm form = new LanguageForm();
            if (form.ShowDialog(this) == DialogResult.OK)
            {
                Language language = form.Language;
                cboLanguages.Items.Add(language);
                language.Serialize();

                cboLanguages.SelectedIndex = cboLanguages.Items.Count - 1;
            }
        }

        private void editButton_Click(object sender, EventArgs e)
        {
            if (cboLanguages.SelectedItem == null)
            {
                MessageBox.Show(this, "Select a language", "Info", MessageBoxButtons.OK, MessageBoxIcon.Information);
                return;
            }

            LanguageForm form = new LanguageForm();
            form.Language = (Language)cboLanguages.SelectedItem;
            if (form.ShowDialog(this) == DialogResult.OK)
            {
                // Delete and remove old language
                Language language = (Language)cboLanguages.SelectedItem;
                File.Delete(language.Name + ".xml");
                cboLanguages.Items.RemoveAt(cboLanguages.SelectedIndex);
                cboLanguages.Invalidate();

                language = form.Language;
                cboLanguages.Items.Add(language);
                language.Serialize();

                cboLanguages.SelectedIndex = cboLanguages.Items.Count - 1;
            }
        }

        private void deleteButton_Click(object sender, EventArgs e)
        {
            if (cboLanguages.SelectedItem == null)
            {
                MessageBox.Show(this, "Select a language", "Info", MessageBoxButtons.OK, MessageBoxIcon.Information);
                return;
            }

            if (MessageBox.Show("Are you sure?", "Confirm", MessageBoxButtons.YesNo) == DialogResult.Yes)
            {
                Language language = (Language)cboLanguages.SelectedItem;
                File.Delete(language.Name + ".xml");
                cboLanguages.Items.RemoveAt(cboLanguages.SelectedIndex);
                cboLanguages.Invalidate();

                cboLanguages.SelectedIndex = cboLanguages.Items.Count - 1;
            }
        }
    }
}
