﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using sharphook;

namespace TestSharpHook
{
    public partial class MainWindow : Form
    {
        private SharpHook hook = null;

        public MainWindow()
        {
            InitializeComponent();

            hook = new SharpHook();
            hook.KeyDown += new KeyEventHandler(hook_KeyDown);
            hook.KeyPress += new KeyPressEventHandler(hook_KeyPress);
            hook.KeyUp += new KeyEventHandler(hook_KeyUp);
        }

        void hook_KeyDown(object sender, KeyEventArgs e)
        {
            textBox1.Text += "KeyDown: " + e.KeyCode.ToString() + Environment.NewLine;
        }

        void hook_KeyPress(object sender, KeyPressEventArgs e)
        {
            textBox1.Text += "KeyPress: " + e.KeyChar.ToString() + Environment.NewLine;
        }

        void hook_KeyUp(object sender, KeyEventArgs e)
        {
            textBox1.Text += "KeyUp: " + e.KeyCode.ToString() + Environment.NewLine;
        }

        private void MainWindow_FormClosing(object sender, FormClosingEventArgs e)
        {
            hook.Dispose();
        }
    }
}
