﻿using System;
using System.Diagnostics;
using System.Runtime.InteropServices;
using System.Text;
using System.Windows.Forms;

namespace sharphook
{
    public class SharpHook : IDisposable
    {
        IntPtr hHook = IntPtr.Zero;

        private Win32API.HookProc hook = null;

        public event KeyEventHandler KeyDown;
        public event KeyPressEventHandler KeyPress;
        public event KeyEventHandler KeyUp;

        public SharpHook()
        {
            hook = new Win32API.HookProc(HookProc);

            using (Process process = Process.GetCurrentProcess())
            using (ProcessModule module = process.MainModule)
            {
                IntPtr hModule = Win32API.GetModuleHandle(module.ModuleName);

                hHook = Win32API.SetWindowsHookEx(Win32API.HookType.WH_KEYBOARD_LL, hook, hModule, 0);
            }
        }

        #region IDisposable Members

        public void Dispose()
        {
            if (hHook != IntPtr.Zero)
            {
                Win32API.UnhookWindowsHookEx(hHook);
            }
        }

        #endregion

        private int HookProc(int code, IntPtr wParam, IntPtr lParam)
        {
            if ((code >= 0) && (KeyDown != null || KeyUp != null || KeyPress != null))
            {
                Win32API.KBDLLHOOKSTRUCT hookStruct = (Win32API.KBDLLHOOKSTRUCT)Marshal.PtrToStructure(lParam, typeof(Win32API.KBDLLHOOKSTRUCT));

                if (KeyDown != null && (wParam.ToInt32() == (int)Win32API.WM.KEYDOWN || wParam.ToInt32() == (int)Win32API.WM.SYSKEYDOWN))
                {
                    Keys keyData = (Keys)hookStruct.vkCode;
                    KeyEventArgs e = new KeyEventArgs(keyData);
                    KeyDown(this, e);
                }

                if (KeyPress != null && wParam.ToInt32() == (int)Win32API.WM.KEYDOWN)
                {
                    byte[] lpKeyState = new byte[256];
                    Win32API.GetKeyboardState(lpKeyState);

                    StringBuilder lpChar = new StringBuilder(2);
                    if (Win32API.ToAscii(hookStruct.vkCode, hookStruct.scanCode, lpKeyState, lpChar, (uint)hookStruct.flags) == 1)
                    {
                        KeyPressEventArgs e = new KeyPressEventArgs((char)lpChar.ToString()[0]);
                        KeyPress(this, e);
                    }
                }

                if (KeyUp != null && (wParam.ToInt32() == (int)Win32API.WM.KEYUP || wParam.ToInt32() == (int)Win32API.WM.SYSKEYUP))
                {
                    Keys keyData = (Keys)hookStruct.vkCode;
                    KeyEventArgs e = new KeyEventArgs(keyData);
                    KeyUp(this, e);
                }

            }
            return Win32API.CallNextHookEx(hHook, code, wParam, lParam);
        }
    }
}
