using System;
using System.Collections.Generic;
using System.Text;

namespace toolbag
{
    public class Log
    {
        private static Log instance = null;
        private List<ApplicationLog> logs = new List<ApplicationLog>();

        public static Log GetInstance
        {
            get
            {
                if (instance == null)
                {
                    instance = new Log();
                }
                return instance;
            }
        }

        private Log()
        {
        }

        public void Add(ApplicationLog log)
        {
            logs.Add(log);
        }

        private void WriteToLogs(string message, ApplicationLog.LogLevel logLevel)
        {
            foreach (ApplicationLog log in logs)
            {
                log.Write(message, logLevel);
            }
        }

        private static void Write(string message, ApplicationLog.LogLevel logLevel)
        {
            Log log = Log.GetInstance;
            log.WriteToLogs(message, logLevel);
        }

        public static void Write(string message)
        {
            Write(message, ApplicationLog.LogLevel.Information);
        }

        public static void Warning(string message)
        {
            Write(message, ApplicationLog.LogLevel.Warning);
        }

        public static void Error(string message)
        {
            Write(message, ApplicationLog.LogLevel.Error);
        }

        public static void Exception(Exception ex)
        {
            Write(ex.ToString(), ApplicationLog.LogLevel.Error);
        }
    }
}