using System;
using System.IO;
using System.Diagnostics;

namespace toolbag
{
    public class FileLog : ApplicationLog, IDisposable
    {
        protected string filename = "application.log";
        protected bool append = false;
        private TextWriter writer = null;

        public FileLog()
            : this("application.log")
        {
        }

        public FileLog(string filename)
            : this(filename, false)
        {
            this.filename = filename;
        }

        public FileLog(string filename, bool append)
            : this(filename, append, LogLevel.Information)
        {
        }

        public FileLog(string filename, bool append, LogLevel logLevel)
            : base(logLevel)
        {
            this.filename = filename;
            this.append = append;
            try
            {
                if (!append)
                {
                    File.Delete(filename);
                }
                writer = new StreamWriter(filename, true);
            }
            catch (Exception ex)
            {
                Debug.Write(ex.Message);
            }
        }

        protected override void WriteLogEntry(string message, LogLevel logLevel)
        {
            try
            {
                message = PrepareMessage(message);
                string symbol = string.Empty;
                switch (logLevel)
                {
                    case LogLevel.Information:
                        symbol = "[i]";
                        break;
                    case LogLevel.Warning:
                        symbol = "[!]";
                        break;
                    case LogLevel.Error:
                        symbol = "[X]";
                        break;
                }
                writer.WriteLine(symbol + " " + message);
                writer.Flush();
            }
            catch (Exception ex)
            {
                Debug.Write(ex);
            }
        }

        public void Dispose()
        {
            writer.Flush();
            writer.Close();
        }
    }
}
