using System;
using System.Diagnostics;

using toolbag;

namespace test_toolbag
{
    class Program
    {
        static void Main(string[] args)
        {
            // Adds a file log
            Log.GetInstance.Add(new FileLog("info.log", false));

            // Adds a file log that tracks errors only
            Log.GetInstance.Add(new FileLog("error.log", true, ApplicationLog.LogLevel.Error));

            // Adds a xml file log
            Log.GetInstance.Add(new XmlLog("info.xml"));

            // A console log
            Log.GetInstance.Add(new ConsoleLog());


            Log.Write("Lorem ipsum");
            
            Log.Warning("Be careful");
            
            Log.Error("Wrong answer!");

            Log.Exception(new Exception("Don't worry this is a fake exception..."));

            Console.Read();
        }
    }
}
