﻿using System;
using System.Diagnostics;
using System.IO;
using System.Text;
using System.Xml;

namespace toolbag
{
    public class XmlLog : FileLog
    {
        private XmlDocument document = null;

        public XmlLog()
            : this("log.xml")
        {
        }

        public XmlLog(string filename)
            : this(filename, false)
        {
        }

        public XmlLog(string filename, bool append)
            : this(filename, append, LogLevel.Information)
        {
        }

        public XmlLog(string filename, bool append, LogLevel logLevel)
        {
            this.filename = filename;
            this.append = append;
            this.logLevel = logLevel;
            try
            {
                if (!append)
                {
                    File.Delete(filename);
                    XmlTextWriter writer = new XmlTextWriter(filename, Encoding.UTF8);
                    writer.Formatting = Formatting.Indented;
                    writer.WriteStartDocument(true);
                    writer.WriteStartElement("logs");
                    writer.WriteEndElement();
                    writer.WriteEndDocument();
                    writer.Close();
                }
                document = new XmlDocument();
                document.Load(filename);
            }
            catch (Exception ex)
            {
                Debug.Write(ex.Message);
            }
        }

        protected override void WriteLogEntry(string message, LogLevel logLevel)
        {
            try
            {
                XmlElement element = document.CreateElement("log");
                element.InnerText = PrepareMessage(message, LogProperties.Assembly | LogProperties.Method);

                XmlAttribute attribute = document.CreateAttribute("date");
                attribute.Value = DateTime.Now.ToString("ddMMyy HHmmss");
                element.Attributes.Append(attribute);

                attribute = document.CreateAttribute("level");
                attribute.Value = logLevel.ToString();
                element.Attributes.Append(attribute);

                document.DocumentElement.AppendChild(element);

                document.Save(filename);
            }
            catch (Exception ex)
            {
                Debug.Write(ex);
            }
        }
    }
}
