using System;
using System.Diagnostics;
using System.Net;
using System.Net.Mail;
using System.Text;

namespace toolbag
{
    public class EmailLog : ApplicationLog
    {
        private string from;
        private string to;
        private string subject;
        private string server = "localhost";
        private bool credentials = false;
        private string username;
        private string password;

        public EmailLog(string from, string to, string subject)
        {
            this.from = from;
            this.to = to;
            this.subject = subject;
        }

        public EmailLog(string from, string to, string subject, string server)
            : this(from, to, subject)
        {
            this.server = server;
        }

        public EmailLog(string from, string to, string subject, string username, string password)
            : this(from, to, subject, "localhost")
        {
        }

        public EmailLog(string from, string to, string subject, string server, string username, string password)
            : this(from, to, subject, server)
        {
            credentials = true;
            this.username = username;
            this.password = password;
        }

        protected override void WriteLogEntry(string message, LogLevel logLevel)
        {
            try
            {
                MailMessage mailMessage = new MailMessage();
                mailMessage.From = new MailAddress(from);
                string[] addresses = to.Split(new char[] { ';' });
                foreach (string address in addresses)
                {
                    mailMessage.To.Add(new MailAddress(address));
                }
                mailMessage.Subject = subject;
                mailMessage.Body = message;
                SmtpClient client = new SmtpClient(server);
                client.UseDefaultCredentials = !credentials;
                if (credentials)
                {
                    NetworkCredential networkCredential = new NetworkCredential(username, password);
                    client.Credentials = networkCredential;
                }
                else
                {
                    //client.Credentials = CredentialCache.DefaultNetworkCredentials;
                }
                client.Send(mailMessage);
            }
            catch (Exception ex)
            {
                Debug.Write(ex.Message);
                throw ex;
            }
        }
    }
}
