using System;
using System.Diagnostics;

namespace toolbag
{
    public class EventLog : ApplicationLog
    {
        private string source;

        public EventLog()
            : this("Application")
        {
        }

        public EventLog(string source)
            : base()
        {
            this.source = source;
            if (System.Diagnostics.EventLog.SourceExists(source))
            {
                System.Diagnostics.EventLog log = new System.Diagnostics.EventLog();
                log.Source = source;
                log.Clear();
            }
        }

        protected override void WriteLogEntry(string message, LogLevel logLevel)
        {
            if (!System.Diagnostics.EventLog.SourceExists(source))
            {
                try
                {
                    System.Diagnostics.EventLog.CreateEventSource(source, source);
                }
                catch (Exception ex)
                {
                    Debug.WriteLine(ex.Message);
                }
            }

            System.Diagnostics.EventLog log = new System.Diagnostics.EventLog();
            log.Source = source;

            try
            {
                EventLogEntryType entryType = EventLogEntryType.Information;
                if (logLevel == LogLevel.Error)
                {
                    entryType = EventLogEntryType.Error;
                }
                else if (logLevel == LogLevel.Warning)
                {
                    entryType = EventLogEntryType.Warning;
                }
                log.WriteEntry(PrepareMessage(message), entryType);
                log.Dispose();
            }
            catch (Exception ex)
            {
                Debug.WriteLine(ex.Message);
                // Possibly failed to write because of full log
                log.Clear();
            }
        }
    }
}
