using System;
using System.Runtime.InteropServices;
using System.Text;

namespace toolbag
{
    public class ConsoleLog : ApplicationLog
    {
        private enum ConsoleColor
        {
            White = 0x7,
            Yellow = 0xE,
            Red = 0xC
        }

        public ConsoleLog()
            : base()
        {
        }

        public ConsoleLog(LogLevel logLevel)
            : base(logLevel)
        {
        }

        protected override void WriteLogEntry(string message, LogLevel logLevel)
        {
                message = PrepareMessage(message);
                SetColor(ConsoleColor.White);
                if (logLevel == LogLevel.Error)
                {
                    SetColor(ConsoleColor.Red);
                }
                else if (logLevel == LogLevel.Warning)
                {
                    SetColor(ConsoleColor.Yellow);
                }
                Console.WriteLine(message);
                // Reset to default color
                SetColor(ConsoleColor.White);
        }

        [DllImportAttribute("Kernel32.dll")]
        private static extern IntPtr GetStdHandle(int nStdHandle);

        [DllImportAttribute("Kernel32.dll")]
        private static extern bool SetConsoleTextAttribute(IntPtr hConsoleOutput, int wAttributes);

        private static bool SetColor(ConsoleColor color)
        {
            IntPtr console = GetStdHandle(-11);
            return SetConsoleTextAttribute(console, (int)color);
        }

    }
}
