﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace sharpcapture
{
    public partial class Toolbox : Form
    {
        const int BUTTON_SIZE = 30;

        public enum Tool
        {
            Line,
            Path,
            Rectangle,
            Ellipse,
        }

        private Tool selectedTool;
        private Color selectedColor;

        public Tool SelectedTool
        {
            get { return selectedTool; }
            set { selectedTool = value; }
        }

        public Color SelectedColor
        {
            get { return selectedColor; }
            set { selectedColor = value; }
        }

        private Button colorButton;

        public Toolbox()
        {
            InitializeComponent();

            selectedTool = Tool.Line;

            selectedColor = Color.Black;

            Button button = null;

            for (int i = 0; i < 4; i++)
            {
                string[] names = (string[])Enum.GetNames(typeof(Tool));
                string name = names[i];
                button = new Button();
                button.Location = new Point((i % 2) * BUTTON_SIZE, (i / 2) * BUTTON_SIZE);
                button.Size = new Size(BUTTON_SIZE, BUTTON_SIZE);
                button.Click += new EventHandler(button_Click);
                button.Name = name;
                button.FlatStyle = FlatStyle.Popup;
                button.Image = Image.FromFile(name + ".png");
                button.TabIndex = i;
                Controls.Add(button);
            }

            colorButton = new Button();
            colorButton.Location = new Point(0, 2 * BUTTON_SIZE);
            colorButton.Size = new Size(BUTTON_SIZE, BUTTON_SIZE);
            colorButton.Click += new EventHandler(button_Click);
            colorButton.Name = "Color";
            colorButton.FlatStyle = FlatStyle.Popup;
            colorButton.Image = CreateColorImage(selectedColor);
            colorButton.TabIndex = 4;
            Controls.Add(colorButton);

            ClientSize = new Size(2 * BUTTON_SIZE, 3 * BUTTON_SIZE);
        }

        private Bitmap CreateColorImage(Color color)
        {
            Bitmap bitmap = new Bitmap(BUTTON_SIZE - 3, BUTTON_SIZE - 3);
            Graphics graphics = Graphics.FromImage(bitmap);
            graphics.Clear(color);
            return bitmap;
        }

        private void button_Click(object sender, EventArgs e)
        {
            Button button = (Button)sender;

            switch (button.Name)
            {
                case "Color":
                    colorDialog1.Color = selectedColor;
                    if (colorDialog1.ShowDialog(this) == DialogResult.OK)
                    {
                        selectedColor = colorDialog1.Color;
                        colorButton.Image = CreateColorImage(selectedColor);
                    }
                    break;
                default:
                    int[] array = (int[])Enum.GetValues(typeof(Tool));
                    selectedTool = (Tool)array[button.TabIndex];
                    break;
            }
        }
    }
}
