﻿using System;
using System.Collections.Generic;

public class World
{
    private List<Shape> shapes;

    public List<Shape> Shapes
    {
        get { return shapes; }
        set { shapes = value; }
    }

    public World()
    {
        shapes = new List<Shape>();
    }

    public void Add(Shape shape)
    {
        shapes.Add(shape);
    }

    public void Update()
    {
        // Update objects
        foreach (Shape shape in shapes)
        {
            shape.Update();
        }

        // Check collisions
        foreach (Shape actor in Shapes)
        {
            if (actor.Speed.GetLength() > 0)
            {
                Vector vector = actor.Speed;
                foreach (Shape shape in Shapes)
                {
                    if (shape != actor)
                    {
                        Vector minVectorToObstacle = null;
                        double length = -1;

                        foreach (Vector o in shape.Lines())
                        {
                            Vector vectorToObstacle = vector.ShortestDistance(o);

                            if (vectorToObstacle.GetLength() <= actor.Border)
                            {
                                Point p = vectorToObstacle.GetIntersection(o);
                                if (o.IntersectsWith(p))
                                {
                                    if (length < 0 || length > vectorToObstacle.GetLength()) minVectorToObstacle = vectorToObstacle;
                                }
                            }
                        }

                        if (minVectorToObstacle != null)
                        {
                            actor.bounce(minVectorToObstacle, shape);
                        }
                    }
                }
            }
        }
    }
}