﻿using System;
using System.Collections.Generic;

public class Shape
{
    private Vector speed;
    private double friction;
    private double border;
    private double gravity;

    public Vector Speed
    {
        get { return speed; }
        set { speed = value; }
    }

    public double Friction
    {
        get { return friction; }
        set { friction = value; }
    }

    public double Border
    {
        get { return border; }
        set { border = value; }
    }

    public double Gravity
    {
        get { return gravity; }
        set { gravity = value; }
    }

    public Shape()
    {
        speed = new Vector();
    }

    public Shape(double x, double y) : this()
    {
        speed.x = x;
        speed.y = y;
        speed.dX = 0;
        speed.dY = 0;
    }

    public virtual void Update()
    {
        speed.x += speed.dX;
        speed.y += speed.dY;
    }

    public virtual List<Vector> Lines()
    {
        return new List<Vector>();
    }

    public void bounce(Vector v2, Shape shape)
    {
        Vector v1 = Speed;
        double radius = Border;
        Vector reverse = new Vector(v2.x, v2.y, -v2.dX, -v2.dY);
        reverse.SetLength((radius + 0.1) - v2.GetLength()); // This one works for horizontal collisions
        //reverse.SetLength((radius) - v2.GetLength()); // This one works to avoid infinite ground bouncing
        Point reverseEP = reverse.GetEndpoint();

        //surface off of  which reflection will occur
        Vector surface = v2.LeftNormal();
        Vector proj1 = v1.Project(v2);
        Vector proj2 = v1.Project(surface);
        proj1.dX *= -1;
        proj1.dY *= -1;
        Vector reflection = proj1 + proj2;
        reflection.x = reverseEP.X;
        reflection.y = reverseEP.Y;

        if (proj1.Dot(v2) > 0)
        {
            reflection.dX = v1.dX;
            reflection.dY = v1.dY;
        }
        v1.Reset(reflection);

        v1.dX = (1 - shape.Friction) * v1.dX; // Friction
        v1.dY = (1 - Gravity) * v1.dY; // Gravity
    }
}