﻿using System;

public class Point
{
    public double x;
    public double y;

    public double X
    {
        get { return x; }
        set { x = value; }
    }

    public double Y
    {
        get { return y; }
        set { y = value; }
    }

    public Point(double x, double y)
    {
        this.x = x;
        this.y = y;
    }

    public static Point Polar(double length, double angle)
    {
        return new Point(length * Math.Cos(angle), length * Math.Sin(angle));
    }

    public override string ToString()
    {
        return "X: " + x + " Y: " + y;
    }
}
