﻿using System;

public abstract class Shape
{
    private Vector position;

    public Vector Position
    {
        get { return position; }
        set { position = value; }
    }

    public Shape()
    {
        position = new Vector();
    }

    public Shape(double x, double y) : this()
    {
        position.dX = x;
        position.dY = y;
    }

    public virtual void Update()
    {
        position.x += position.dX;
        position.y += position.dY;
    }

    public abstract void Draw(allegro.BITMAP buffer);
}