using System;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Collections.Generic;

using allegro;

class Program : Allegro
{
    static BITMAP buffer;
    static World world = new World();

    static void Init()
    {
        allegro_init();
        set_window_title("sharpcollision");
        set_color_depth(32);
        set_gfx_mode(GFX_AUTODETECT_WINDOWED, 320, 200, 0, 0);
        install_timer();
        install_keyboard();
        install_mouse();

        buffer = create_bitmap(320, 200);

        position_mouse(160, 100);
    }

    static void Draw()
    {
        clear_to_color(buffer, makecol(0, 0, 0));
        foreach (Shape shape in world.Shapes)
        {
            if (shape is Circle)
            {
                Sprite.Draw((Circle)shape, buffer);
            }
            else if (shape is Box)
            {
                Sprite.Draw((Box)shape, buffer);
            }
            else if (shape is Polygon)
            {
                Sprite.Draw((Polygon)shape, buffer);
            }
        }
        blit(buffer, screen, 0, 0, 0, 0, 320, 200);

        //line(buffer, (int)vectorToObstacle.x, (int)vectorToObstacle.y, (int)(vectorToObstacle.x + vectorToObstacle.dX), (int)(vectorToObstacle.y + vectorToObstacle.dY), makecol(0, 0, 255));
    }

    static void Update(Circle c)
    {
        world.Update();
    }

    static void Main(string[] args)
    {
        Init();

        Circle c = new Circle();
        c.Border = 10;
        c.Speed = new Vector(20, 50, 5f, 2f);
        c.Gravity = 0.3f;

        Polygon poly = new Polygon();
        poly.Add(new Point(10, 170));
        poly.Add(new Point(110, 190));
        poly.Add(new Point(10, 190));
        poly.Friction = 0.1f;

        
        world.Add(c);
        Box b = new Box(160, 100, 300, 180);
        b.Friction = 0.1f;
        world.Add(b);
        world.Add(new Box(180, 140, 100, 20));
        world.Add(new Box(200, 35, 50, 50));
        world.Add(new Box(250, 35, 50, 50));
        world.Add(poly);

        Box b2 = new Box(30, 30, 20, 20);
        b2.Speed.dX = 1;
        // TODO: border for rectangles???
        b2.Border = 10;
        world.Add(b2);

        int step = Timer.Instance.Time;

        while (!key[KEY_ESC])
        {
            Draw();

            if (Timer.Instance.elapsedTime(step) > 20)
            {
                Update(c);

                step = Timer.Instance.Time;
            }
        }
    }
}

