﻿using System;
using System.Collections.Generic;

public class Polygon : Shape
{
    private List<Point> points;

    public List<Point> Points
    {
        get { return points; }
        set { points = value; }
    }

    public Polygon()
    {
        points = new List<Point>();
    }

    public void Add(Point point)
    {
        points.Add(point);
    }

    public override List<Vector> Lines()
    {
        List<Vector> temp = new List<Vector>(points.Count);
        Point p0 = null;
        foreach (Point p in points)
        {
            if (p0 == null)
            {
                p0 = p;
            }
            else
            {
                temp.Add(new Vector(p0, p));
            }
        }
        temp.Add(new Vector(p0, points[0]));
        return temp;
    }
}