﻿using System;
using System.Collections.Generic;

public class Box : Shape
{
    private int width;
    private int height;

    public int Width
    {
        get { return width; }
        set { width = value; }
    }   

    public int Height
    {
        get { return height; }
        set { height = value; }
    }

    public Box(double x, double y, int width, int height)
        : base(x , y)
    {
        this.width = width;
        this.height = height;
    }

    public override List<Vector> Lines()
    {
        List<Vector> temp = new List<Vector>(4);
        // Top
        temp.Add(new Vector(Speed.x - width / 2, Speed.y - height / 2, width, 0));
        // Right
        temp.Add(new Vector(Speed.x + width / 2, Speed.y - height / 2, 0, height));
        // Bottom
        temp.Add(new Vector(Speed.x - width / 2, Speed.y + height / 2, width, 0));
        // Left
        temp.Add(new Vector(Speed.x - width / 2, Speed.y - height / 2, 0, height));
        return temp;
    }
}
