﻿using System;

using allegro;

public abstract class Sprite : Allegro
{
    public static void Draw(Circle c, BITMAP buffer)
    {
        circle(
            buffer,
            (int)c.Speed.x,
            (int)c.Speed.y,
            (int)c.Border,
            makecol(255, 0, 0));
        line(
            buffer,
            (int)c.Speed.x,
            (int)c.Speed.y,
            (int)(c.Speed.x + c.Speed.dX),
            (int)(c.Speed.y + c.Speed.dY),
            makecol(255, 255, 255));
    }

    public static void Draw(Box b, BITMAP buffer)
    {
        foreach (Vector v in b.Lines())
        {
            line(buffer, (int)v.x, (int)v.y, (int)(v.x + v.dX), (int)(v.y + v.dY), allegro.Allegro.makecol(0, 255, 0));
        }
    }

    public static void Draw(Polygon p, BITMAP buffer)
    {
        foreach (Vector v in p.Lines())
        {
            line(buffer, (int)v.x, (int)v.y, (int)(v.x + v.dX), (int)(v.y + v.dY), allegro.Allegro.makecol(0, 255, 255));
        }
    }
}