using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.CodeDom.Compiler;
using System.Reflection;
using System.Collections;
using Microsoft.CSharp;
using System.IO;
using System.Text.RegularExpressions;
using System.CodeDom;

namespace SharpConsole
{
  public partial class Form1 : Form
  {
    public Form1()
    {
      InitializeComponent();

      textBox2.Settings.Keywords.AddRange(new string[] { "if", "then", "else" });
      textBox2.Settings.Keywords.AddRange(new string[] { "sbyte", "byte", "short", "int", "uint", "long", "float", "double", "decimal", "char", "bool", "date", "string" });
      textBox2.Settings.Keywords.AddRange(new string[] { "String", "Boolean", "Int16", "Int32", "Int64", "DateTime" });

      textBox2.Settings.Comment = "//";

      textBox2.Settings.KeywordColor = Color.Blue;
      textBox2.Settings.CommentColor = Color.Green;
      textBox2.Settings.StringColor = Color.Gray;
      textBox2.Settings.IntegerColor = Color.Red;

      textBox2.CompileKeywords();
    }

    static ArrayList commands = new ArrayList();
    int commandIndex = 0;

    static string funcprefix =
      @"using System;
        using System.IO;
        using System.Text;
        public delegate void Proc();

        public class Wrapper {
          public static object Set(string name, object value) {
            AppDomain.CurrentDomain.SetData(name, value);
            return value;
          }
          public static object Get(string name) {
            return AppDomain.CurrentDomain.GetData(name);
          }
          public static object Invoke(Proc proc) {
            proc();
            return null;
          }
          public static string Eval() {
            StringWriter writer = new StringWriter();
            Console.SetOut(writer);";
    static string funcsuffix =
      @"return writer.ToString();
          }
        }";


    string StringEval(string expr)
    {
      //string program = string.Format(funcprefix, expr, "writer.ToString()");
      string program = funcprefix + Environment.NewLine + expr + Environment.NewLine + funcsuffix;
      //funcprefix = funcprefix.Replace("\r\n", "");
      //string program = string.Format(funcprefix, expr);


      ICodeCompiler compiler = CodeDomProvider.CreateProvider("C#").CreateCompiler();
      //ICodeCompiler compiler = new CSharpCodeProvider().CreateCompiler();
      CompilerParameters cp = new CompilerParameters();
      cp.GenerateExecutable = false;
      cp.GenerateInMemory = true;      


      CompilerResults results = compiler.CompileAssemblyFromSource(cp, program);
      if (results.Errors.HasErrors)
      {
        if (results.Errors[0].ErrorNumber == "CS0029")
          return StringEval("Invoke(delegate { " + expr + "; })");
        return results.Errors[0].ErrorText;
      }
      else
      {
        Assembly assm = results.CompiledAssembly;
        Type target = assm.GetType("Wrapper");
        MethodInfo method = target.GetMethod("Eval");
        object result = method.Invoke(null, null);
        return result == null ? null : result.ToString();
      }
    }

    private void log(string message)
    {
      textBox1.Text += message + Environment.NewLine;
    }

    private void toolStripButton1_Click(object sender, EventArgs e)
    {
      string command = textBox2.Text.Trim();

      if (command != "")
      {
        //ICodeParser parser = new CSharpCodeProvider().CreateParser();
        //CodeCompileUnit unit = parser.Parse(new StringReader(command));


        try
        {
          string result = StringEval(command);
          commands.Add(command);
          commandIndex = commands.Count;
          textBox1.Text = "";
          //log("> " + command);
          log(result);
        }
        catch (TargetInvocationException ex)
        {
          MessageBox.Show(ex.InnerException.GetType().Name + ": " + ex.InnerException.Message);
          //log(ex.InnerException.GetType().Name + ": " + ex.InnerException.Message);
        }
        catch (Exception ex)
        {
          log(ex.GetType().Name + ": " + ex.Message);
        }
        
      }
    }

    private void textBox2_TextChanged(object sender, EventArgs e)
    {
      // Calculate the starting position of the current line.
      int start = 0, end = 0;
      
      for (start = textBox2.SelectionStart - 1; start > 0; start--)
      {
        if (textBox2.Text[start] == '\n') { start++; break; }
      }
      // Calculate the end position of the current line.
      for (end = textBox2.SelectionStart; end < textBox2.Text.Length; end++)
      {
        if (textBox2.Text[end] == '\n') break;
      }
      // Extract the current line that is being edited.
      String line = textBox2.Text.Substring(start, end - start);
      // Backup the users current selection point.
      int selectionStart = textBox2.SelectionStart;
      int selectionLength = textBox2.SelectionLength;
      // Split the line into tokens.
      Regex r = new Regex("([ \\t{}();])");
      string[] tokens = r.Split(line);
      int index = start;
      foreach (string token in tokens)
      {
        // Set the token's default color and font.
        textBox2.SelectionStart = index;
        textBox2.SelectionLength = token.Length;
        textBox2.SelectionColor = Color.Black;
        textBox2.SelectionFont = new Font("Courier New", 10,
        FontStyle.Regular);
        // Check whether the token is a keyword.
        String[] keywords = { "public", "void", "using", "static", "class" };
        for (int i = 0; i < keywords.Length; i++)
        {
          if (keywords[i] == token)
          {
            // Apply alternative color and font to highlight keyword.
            textBox2.SelectionColor = Color.Blue;
            textBox2.SelectionFont = new Font("Courier New", 10, FontStyle.Bold);
            break;
          }

          index += token.Length;
        }
        // Check whether the token is a type.
        String[] types = { "int" };
        for (int i = 0; i < types.Length; i++)
        {
          if (types[i] == token)
          {
            // Apply alternative color and font to highlight keyword.
            textBox2.SelectionColor = Color.Red;
            textBox2.SelectionFont = new Font("Courier New", 10, FontStyle.Bold);
            break;
          }

          index += token.Length;
        }
        // Restore the users current selection point.
        textBox2.SelectionStart = selectionStart;
        textBox2.SelectionLength = selectionLength;
      } 
    }

    private void textBox3_KeyUp(object sender, KeyEventArgs e)
    {
      if (e.KeyCode == Keys.Enter && textBox3.Text.Trim() != "")
      {
        textBox4.Text = StringEval("Console.Write(" + textBox3.Text + ");");
        textBox3.Text = "";
      }
      else if (e.KeyCode == Keys.Up)
      {
        if (commands.Count > 0)
        {
          commandIndex--;
          if (commandIndex == -1) commandIndex = commands.Count - 1;
          textBox3.Text = (string)commands[commandIndex];
          textBox3.SelectionStart = textBox3.Text.Length;
        }
      }
    }

    private void textBox6_TextChanged(object sender, EventArgs e)
    {
      try
      {
        textBox5.ForeColor = Color.Green;
        if (Regex.IsMatch(textBox6.Text, textBox5.Text))
        {
          textBox6.ForeColor = Color.Green;
        }
        else
        {
          textBox6.ForeColor = Color.Red;
        }
      }
      catch
      {
        textBox5.ForeColor = Color.Red;
      }
    }
  }
}